/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.opensocial.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.gadgets.oauth.BasicOAuthStore;
import org.apache.shindig.gadgets.oauth.BasicOAuthStoreConsumerKeyAndSecret;
import org.apache.shindig.gadgets.oauth.OAuthModule;
import org.apache.shindig.gadgets.oauth.OAuthRequest;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CQOAuthModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(CQOAuthModule.class);
    private static final String OAUTH_CONFIG = "config/oauth.json";
    private static final String OAUTH_SIGNING_KEY_FILE = "shindig.signing.key-file";
    private static final String OAUTH_SIGNING_KEY_NAME = "shindig.signing.key-name";
    private static final String OAUTH_CALLBACK_URL = "shindig.signing.global-callback-url";

    protected void configure() {
        this.bind(BlobCrypter.class).annotatedWith((Annotation)Names.named((String)"shindig.oauth.state-crypter")).toProvider(OAuthModule.OAuthCrypterProvider.class);
        this.bind(OAuthStore.class).toProvider(CQOAuthStoreProvider.class);
        this.bind(OAuthRequest.class).toProvider(OAuthModule.OAuthRequestProvider.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    public static class CQOAuthStoreProvider
    implements Provider<OAuthStore> {
        private final BasicOAuthStore store = new BasicOAuthStore();

        @Inject
        public CQOAuthStoreProvider(@Named(value="shindig.signing.key-file") String signingKeyFile, @Named(value="shindig.signing.key-name") String signingKeyName, @Named(value="shindig.signing.global-callback-url") String defaultCallbackUrl) {
            this.loadDefaultKey(signingKeyFile, signingKeyName);
            this.store.setDefaultCallbackUrl(defaultCallbackUrl);
            this.loadConsumers();
        }

        private void loadDefaultKey(String signingKeyFile, String signingKeyName) {
            BasicOAuthStoreConsumerKeyAndSecret key = null;
            if (!StringUtils.isBlank((String)signingKeyFile)) {
                try {
                    log.info("Loading OAuth signing key from " + signingKeyFile);
                    String privateKey = IOUtils.toString((InputStream)ResourceLoader.open((String)signingKeyFile), (String)"UTF-8");
                    privateKey = BasicOAuthStore.convertFromOpenSsl((String)privateKey);
                    key = new BasicOAuthStoreConsumerKeyAndSecret(null, privateKey, BasicOAuthStoreConsumerKeyAndSecret.KeyType.RSA_PRIVATE, signingKeyName, null);
                }
                catch (Throwable t) {
                    log.warn("Couldn't load key file " + signingKeyFile, t);
                }
            }
            if (key != null) {
                this.store.setDefaultKey(key);
            } else {
                log.info("No outbound OAuth configured for OpenSocial.");
            }
        }

        private void loadConsumers() {
            try {
                String oauthConfigString = ResourceLoader.getContent((String)CQOAuthModule.OAUTH_CONFIG);
                this.store.initFromConfigString(oauthConfigString);
            }
            catch (Throwable t) {
                log.warn("Failed to initialize OAuth consumers from config/oauth.json", t);
            }
        }

        public OAuthStore get() {
            return this.store;
        }
    }
}

