/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization;

import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;

@SlingServlet(methods={"GET"}, resourceTypes={"cq/personalization/touch-ui/datasource/campaignsdatasource"})
public class CampaignsDataSourceServlet
extends SlingSafeMethodsServlet {
    private static final String CAMPAIGNPAGE_RESOURCE_TYPE = "cq/personalization/components/campaignpage";
    private static final String CAMPAIGNS_ROOT = "/content/campaigns";
    private static final String EMPTY_LIST_ENTRY = "(simulation)";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        ArrayList<ValueMapResource> resourceList = new ArrayList<ValueMapResource>();
        ResourceResolver resolver = request.getResourceResolver();
        CampaignsRetriever visitor = new CampaignsRetriever();
        visitor.accept(resolver.getResource(CAMPAIGNS_ROOT));
        Map<String, String> campaigns = visitor.getCampaigns();
        HashMap<String, Object> emptyEntry = new HashMap<String, Object>();
        emptyEntry.put("text", EMPTY_LIST_ENTRY);
        emptyEntry.put("value", "");
        resourceList.add(new ValueMapResource(resolver, new ResourceMetadata(), "", (ValueMap)new ValueMapDecorator(emptyEntry)));
        for (String title : campaigns.keySet()) {
            String path = campaigns.get(title);
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("value", path);
            entry.put("text", title);
            ValueMapResource vmRes = new ValueMapResource(resolver, new ResourceMetadata(), "", (ValueMap)new ValueMapDecorator(entry));
            resourceList.add(vmRes);
        }
        request.setAttribute(DataSource.class.getName(), new SimpleDataSource(resourceList.iterator()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CampaignsRetriever
    extends AbstractResourceVisitor {
        Map<String, String> campaigns = new HashMap<String, String>();

        CampaignsRetriever() {
        }

        @Override
        protected void visit(Resource resource) {
            if (CampaignsDataSourceServlet.CAMPAIGNPAGE_RESOURCE_TYPE.equals(resource.getResourceType())) {
                ValueMap props = resource.adaptTo(ValueMap.class);
                this.campaigns.put(props.get("jcr:title", resource.getParent().getName()), resource.getParent().getPath());
            }
        }

        public Map<String, String> getCampaigns() {
            return this.campaigns;
        }
    }
}

