/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.tags;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.personalization.UserPropertiesUtil;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.TagUtil;

public class ContextProfileLinkTag
extends TagSupport {
    private String href;
    private String displayValue;
    private String displayValuePropertyName;
    private String id;
    private String store;
    private String prefix;
    private String suffix;

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.href = "";
        this.displayValue = null;
        this.displayValuePropertyName = null;
        this.id = "";
        this.store = "profile";
        this.prefix = "";
        this.suffix = "";
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    public void setDisplayValuePropertyName(String displayValuePropertyName) {
        this.displayValuePropertyName = displayValuePropertyName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        SlingHttpServletRequest request = TagUtil.getRequest(this.pageContext);
        try {
            out.println(this.getScript(request, (UserProperties)request.adaptTo(UserProperties.class)));
        }
        catch (IOException e) {
            throw new JspException("Could not write script for context profile link", (Throwable)e);
        }
        return 6;
    }

    String getScript(SlingHttpServletRequest request, UserProperties userProperties) {
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        XSSAPI xssAPI = bindings.getSling().getService(XSSAPI.class).getRequestSpecificAPI(request);
        String value = StringUtils.isNotBlank((String)this.displayValuePropertyName) ? UserPropertiesUtil.getValue(userProperties, this.displayValuePropertyName) : this.displayValue;
        StringBuilder res = new StringBuilder();
        res.append("<a id=\"").append(xssAPI.encodeForHTMLAttr(this.id)).append("\"");
        res.append(" href=\"\">").append(xssAPI.encodeForHTML(this.prefix + value + this.suffix)).append("</a>");
        res.append("<script type=\"text/javascript\">");
        res.append("$CQ(function() {");
        res.append("if( window.CQ_Analytics && CQ_Analytics.CCM) {");
        res.append("CQ_Analytics.ClientContextUtils.onStoreRegistered('").append(xssAPI.encodeForJSString(this.store)).append("', function(store) {");
        res.append("var renderer = function() {");
        res.append("var linkHref = '").append(xssAPI.encodeForJSString(this.href)).append("';");
        res.append("var linkValue = '").append(xssAPI.encodeForJSString(value)).append("';");
        res.append("var p = store.getData();");
        res.append("if (p) {");
        res.append("linkHref = linkHref.replace(/\\$\\{profile\\.path\\}/g, p['path']);");
        if (StringUtils.isNotBlank((String)this.displayValuePropertyName)) {
            res.append("linkValue = store.getProperty('").append(xssAPI.encodeForJSString(this.displayValuePropertyName)).append("') || '';");
        }
        res.append("}");
        res.append("linkValue = '").append(xssAPI.encodeForJSString(this.prefix)).append("' + linkValue + '").append(xssAPI.encodeForJSString(this.suffix)).append("';");
        res.append("var link = document.getElementById('").append(xssAPI.encodeForJSString(this.id)).append("');");
        res.append("if (link && link.href != linkHref) {");
        res.append("link.href = '" + request.getContextPath() + "' + linkHref;");
        res.append("}");
        res.append("if (link && link.innerHTML != linkValue) {");
        res.append("link.innerHTML = linkValue;");
        res.append("}");
        res.append("};");
        res.append("renderer();");
        res.append("store.addListener('update', function() {");
        res.append("renderer();");
        res.append("});");
        res.append("});");
        res.append("}");
        res.append("});");
        res.append("</script>");
        return res.toString();
    }
}

