/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication;

import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import org.apache.sling.event.EventPropertiesMap;
import org.apache.sling.event.EventUtil;
import org.osgi.service.event.Event;

public class ReplicationEvent
implements Serializable {
    public static final String EVENT_TOPIC = "com/adobe/granite/replication";
    public static final String PATHS = "paths";
    private static final String PROPERTY_MODIFICATIONS = "modifications";
    private static final String TYPE = "type";
    private static final String TIME = "time";
    private static final String USER_ID = "userId";
    private static final String REVISION = "revision";
    private ReplicationAction replicationAction;
    private final boolean isLocal;

    public ReplicationEvent(ReplicationAction replicationAction) {
        this(replicationAction, true);
    }

    public ReplicationEvent(ReplicationAction replicationAction, boolean isLocal) {
        this.replicationAction = replicationAction;
        this.isLocal = isLocal;
    }

    public ReplicationAction getReplicationAction() {
        return this.replicationAction;
    }

    public static ReplicationEvent fromEvent(Event evt) {
        if (!evt.getTopic().equals(EVENT_TOPIC)) {
            return null;
        }
        ReplicationAction action = null;
        List modProps = (List)evt.getProperty(PROPERTY_MODIFICATIONS);
        if (modProps != null && modProps.size() == 1) {
            EventPropertiesMap modProp = (EventPropertiesMap)modProps.get(0);
            String[] paths = (String[])modProp.get(PATHS);
            ReplicationActionType type = (ReplicationActionType)((Object)modProp.get(TYPE));
            Long time = (Long)modProp.get(TIME);
            String userId = (String)modProp.get(USER_ID);
            String revision = (String)modProp.get(REVISION);
            action = new ReplicationAction(type, paths, (long)time, userId, revision);
        }
        if (action == null) {
            throw new RuntimeException();
        }
        return new ReplicationEvent(action, EventUtil.isLocal(evt));
    }

    protected EventPropertiesMap getEventProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ArrayList<EventPropertiesMap> modProps = new ArrayList<EventPropertiesMap>();
        EventPropertiesMap actionProps = new EventPropertiesMap();
        actionProps.put(PATHS, (Object)this.replicationAction.getPaths());
        actionProps.put(TYPE, (Object)this.replicationAction.getType());
        actionProps.put(TIME, (Object)this.replicationAction.getTime());
        actionProps.put(USER_ID, (Object)this.replicationAction.getUserId());
        actionProps.put(REVISION, (Object)this.replicationAction.getRevision());
        modProps.add(actionProps);
        properties.put(PROPERTY_MODIFICATIONS, modProps);
        if (!this.isLocal) {
            properties.put("event.application", "unknown");
        }
        return new EventPropertiesMap(properties);
    }

    public Event toEvent() {
        return EventUtil.createDistributableEvent(EVENT_TOPIC, this.getEventProperties());
    }

    public Event toNonDistributableEvent() {
        return new Event(EVENT_TOPIC, (Dictionary)this.getEventProperties());
    }
}

