/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.XPath;
import org.apache.felix.scr.annotations.Component;

@Component(metatype=false, factory="com.day.cq.search.eval.PredicateEvaluator/fulltext")
public class FulltextPredicateEvaluator
extends AbstractPredicateEvaluator {
    public static final String FULLTEXT = "fulltext";
    public static final String REL_PATH = "relPath";

    public String getXPathExpression(Predicate p, EvaluationContext context) {
        if (!p.hasNonEmptyValue(FULLTEXT)) {
            return null;
        }
        return "jcr:contains(" + p.get(REL_PATH, ".") + ", " + XPath.getFulltextStringLiteral(p.get(FULLTEXT)) + ")";
    }

    public boolean canXpath(Predicate predicate, EvaluationContext context) {
        return true;
    }

    public boolean canFilter(Predicate predicate, EvaluationContext context) {
        return false;
    }
}

