/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.searchpromote.xml.result;

import com.day.cq.searchpromote.xml.result.FacetValue;
import com.day.cq.searchpromote.xml.result.ResultEntity;
import com.day.cq.searchpromote.xml.result.ResultParser;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Facet
implements ResultEntity {
    private static final String SELECTED_NODE = "selected";
    private static final String TITLE_NODE = "facet-title";
    private static final String UNDO_LINK_NODE = "undo-link";
    private static final String ITEM_NODE = "facet-value";
    private static final String BEHAVIOR_NODE = "behavior";
    private boolean selected;
    private String title;
    private String undoQueryString;
    private List<FacetValue> items = new ArrayList<FacetValue>();
    private String behavior;

    @Override
    public void parse(XMLEventReader reader) throws Exception {
        XMLEvent event;
        while (reader.hasNext() && !(event = ResultParser.getNextEvent(reader)).isEndElement()) {
            StartElement startElement = event.asStartElement();
            String localPart = startElement.getName().getLocalPart();
            if (localPart.equals(SELECTED_NODE)) {
                this.selected = ResultParser.strToBool(reader.nextEvent().asCharacters().getData());
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (localPart.equals(TITLE_NODE)) {
                this.title = reader.nextEvent().asCharacters().getData();
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (localPart.equals(BEHAVIOR_NODE)) {
                this.behavior = reader.nextEvent().asCharacters().getData();
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (localPart.equals(UNDO_LINK_NODE)) {
                this.undoQueryString = reader.nextEvent().asCharacters().getData();
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (localPart.equals(ITEM_NODE)) {
                FacetValue item = new FacetValue();
                item.parse(reader);
                this.items.add(item);
                continue;
            }
            ResultParser.parseUnknownTag(reader);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUndoQueryString() {
        return this.undoQueryString;
    }

    public Boolean hasUndoQueryString() {
        return this.undoQueryString != null && !"".equals(this.undoQueryString);
    }

    public List<FacetValue> getItems() {
        return this.items;
    }

    public String getBehavior() {
        return this.behavior;
    }
}

