/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.searchpromote.xml.result;

import com.day.cq.searchpromote.xml.result.FacetValueChildList;
import com.day.cq.searchpromote.xml.result.ResultEntity;
import com.day.cq.searchpromote.xml.result.ResultParser;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class FacetValue
implements ResultEntity {
    private static final String LABEL_NODE = "label";
    private static final String COUNT_NODE = "count";
    private static final String LINK_NODE = "link";
    private static final String UNDO_LINK_NODE = "undolink";
    private static final String SELECTED_NODE = "selected";
    private static final String HAS_CHILDREN_NODE = "facet-has-children";
    private static final String CHILDREN_NODE = "children";
    private String label;
    private String undoQueryString;
    private String queryString;
    private Long count;
    private boolean selected;
    private boolean hasChildren;
    private FacetValueChildList childList;

    public void parse(XMLEventReader reader) throws Exception {
        XMLEvent nextEvent;
        while (reader.hasNext() && !(nextEvent = ResultParser.getNextEvent(reader)).isEndElement()) {
            String data;
            StartElement element = nextEvent.asStartElement();
            if (element.getName().getLocalPart().equals(LABEL_NODE)) {
                this.label = data = reader.nextEvent().asCharacters().getData();
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (element.getName().getLocalPart().equals(COUNT_NODE)) {
                data = reader.nextEvent().asCharacters().getData();
                this.count = ResultParser.strToLong(data);
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (element.getName().getLocalPart().equals(LINK_NODE)) {
                this.queryString = data = reader.nextEvent().asCharacters().getData();
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (element.getName().getLocalPart().equals(UNDO_LINK_NODE)) {
                this.undoQueryString = data = reader.nextEvent().asCharacters().getData();
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (element.getName().getLocalPart().equals(SELECTED_NODE)) {
                data = reader.nextEvent().asCharacters().getData();
                this.selected = ResultParser.strToBool(data);
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (element.getName().getLocalPart().equals(HAS_CHILDREN_NODE)) {
                data = reader.nextEvent().asCharacters().getData();
                this.hasChildren = ResultParser.strToBool(data);
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (element.getName().getLocalPart().equals(CHILDREN_NODE)) {
                this.childList = new FacetValueChildList();
                this.childList.parse(reader);
                continue;
            }
            ResultParser.parseUnknownTag(reader);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getUndoQueryString() {
        return this.undoQueryString;
    }

    public Boolean hasUndoQueryString() {
        return this.undoQueryString != null && !"".equals(this.undoQueryString);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Boolean hasQueryString() {
        return this.queryString != null && !"".equals(this.queryString);
    }

    public Long getCount() {
        return this.count;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public FacetValueChildList getChildList() {
        return this.childList;
    }
}

