/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.security.util;

import com.day.cq.commons.JSONWriterUtil;
import com.day.cq.replication.ReplicationQueue;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.security.Authorizable;
import com.day.cq.security.Group;
import com.day.cq.security.User;
import com.day.cq.security.impl.CQAuthorizableImpl;
import com.day.cq.security.profile.Profile;
import com.day.cq.security.profile.ProfileManager;
import com.day.cq.xss.XSSProtectionService;
import java.io.Writer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizableJSONWriter {
    private static final Map<String, String> USER_TO_PROFILE_PROPS;
    private static final Logger log;
    public static final String GROUP = "group";
    public static final String USER = "user";
    public static final String KEY_HOME_PATH = "home";
    private final Session session;
    private final ProfileManager pMgr;
    private Set<String> outputProps;
    private XSSProtectionService xss;
    private boolean basic;
    private int membersLimit = -1;

    public AuthorizableJSONWriter() {
        this(null, null, null, null);
    }

    public AuthorizableJSONWriter(ProfileManager pMgr, Session session, String[] outputProps, XSSProtectionService xss) {
        this.session = session;
        this.pMgr = pMgr;
        this.setOutputProps(outputProps);
        this.xss = xss;
    }

    public void setMembersLimit(int membersLimit) {
        this.membersLimit = membersLimit;
    }

    public void setOutputProps(String[] outputProps) {
        if (outputProps == null) {
            this.outputProps = null;
        } else {
            this.outputProps = new HashSet<String>();
            for (String p : outputProps) {
                this.outputProps.add(p);
            }
        }
    }

    public void setBasic(boolean basic) {
        this.basic = basic;
    }

    public void setXss(XSSProtectionService xss) {
        this.xss = xss;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void write(JSONWriter writer, Authorizable authorizable) throws JSONException {
        writer.object();
        if (!this.basic) {
            profileProps = new HashMap<String, Object>();
            for (Map.Entry<String, String> entry : AuthorizableJSONWriter.USER_TO_PROFILE_PROPS.entrySet()) {
                userPropName = entry.getKey();
                profPropName = entry.getValue();
                value = authorizable.getProperty(userPropName);
                if (value == null) continue;
                profileProps.put(profPropName, value);
            }
            profile = authorizable.getProfile();
            if (profile != null) {
                for (String name : profile.keySet()) {
                    profileProps.put(name, profile.get(name, String.class));
                }
            }
            for (Map.Entry entry : profileProps.entrySet()) {
                JSONWriterUtil.write(writer, (String)entry.getKey(), (String)entry.getValue(), JSONWriterUtil.WriteMode.BOTH, this.xss);
            }
            authorizableNode = authorizable.adaptTo(Node.class);
            try {
                this.write(writer, "jcr:created", authorizableNode.getProperty("jcr:created").getString());
            }
            catch (RepositoryException e) {
                AuthorizableJSONWriter.log.warn("Unable to get {} property from authorizable {}", (Object)"jcr:created", (Object)authorizable.getHomePath());
            }
            try {
                this.write(writer, "jcr:createdBy", authorizableNode.getProperty("jcr:createdBy").getString());
            }
            catch (RepositoryException e) {
                AuthorizableJSONWriter.log.warn("Unable to get {} property from authorizable {}", (Object)"jcr:createdBy", (Object)authorizable.getHomePath());
            }
            this.write(writer, "principal", authorizable.getPrincipal().getName());
            this.writeAuthorizables(writer, "memberOf", authorizable.memberOf(), -1, JSONWriterUtil.WriteMode.BOTH);
            if (authorizable.isUser()) {
                this.write(writer, "rep:userId", authorizable.getID());
                user = (User)authorizable;
                this.writeAuthorizables(writer, "sudoers", user.getImpersonators(), -1, JSONWriterUtil.WriteMode.BOTH);
                try {
                    if (!user.isDisabled()) ** GOTO lbl47
                    this.write(writer, "disabled", user.getDisabledReason());
                }
                catch (RepositoryException e) {
                    throw new JSONException(e);
                }
            } else {
                this.write(writer, "groupName", authorizable.getID());
                this.writeAuthorizables(writer, "members", ((Group)authorizable).members(), this.membersLimit, JSONWriterUtil.WriteMode.BOTH);
            }
lbl47:
            // 3 sources

            itr = authorizable.getPropertyNames();
            while (itr.hasNext()) {
                name = itr.next();
                if ("id".equals(name) || "name".equals(name)) continue;
                this.write(writer, name, authorizable.getProperty(name));
            }
            primPhoto = null;
            if (profile != null && (photos = profile.getPhotos()).hasNext()) {
                primPhoto = photos.next();
            }
            if (primPhoto != null) {
                photoNode = primPhoto.adaptTo(Node.class);
                ext = "png";
                ck = 0L;
                try {
                    content = photoNode.getNode("image").getNode("jcr:content");
                    ck = content.getProperty("jcr:lastModified").getLong();
                    ck = ck / 1000L * 1000L;
                }
                catch (PathNotFoundException e) {
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
                this.write(writer, "picturePath", primPhoto.getPath());
                this.write(writer, "pictureExt", ext);
                this.write(writer, "pictureMod", ck);
            } else {
                this.write(writer, "thumbnail", "");
            }
            this.writeModificationDates(writer, authorizable);
            this.writeReplication(writer, authorizable);
        }
        this.write(writer, "type", authorizable.isUser() != false ? "user" : "group");
        this.write(writer, "id", authorizable.getID());
        JSONWriterUtil.write(writer, "name", authorizable.getName(), JSONWriterUtil.WriteMode.BOTH, this.xss);
        this.write(writer, "home", authorizable.getHomePath());
        writer.endObject();
    }

    public void write(Writer out, Authorizable authorizable) throws JSONException {
        this.write(new JSONWriter(out), authorizable);
    }

    public void writeTable(Writer out, Authorizable authorizable) throws JSONException, RepositoryException {
        JSONWriter writer = new JSONWriter(out);
        writer.object();
        AuthorizableJSONWriter.writeColumnHeader(writer, authorizable);
        this.writeRows(writer, authorizable);
        writer.endObject();
    }

    private void write(JSONWriter writer, String key, String value) throws JSONException {
        if (this.includeKey(key)) {
            JSONWriterUtil.write(writer, key, value, null, this.xss);
        }
    }

    private void write(JSONWriter writer, String key, long value) throws JSONException {
        if (this.includeKey(key)) {
            writer.key(key).value(value);
        }
    }

    private void writeRows(JSONWriter json, Authorizable authorizable) throws JSONException, RepositoryException {
        json.key("rows");
        json.array();
        json.array();
        json.value(authorizable.getID());
        json.array();
        json.value(authorizable.getName());
        if (authorizable.isUser()) {
            json.value(authorizable.getID());
            json.value("***");
        }
        json.value(authorizable.getProfile().getPrimaryMail());
        json.endArray();
        json.endArray();
        json.endArray();
    }

    private static void writeColumnHeader(JSONWriter json, Authorizable authorizable) throws JSONException {
        json.key("columns");
        json.array();
        json.object();
        json.key("id").value("name");
        json.key("text").value("Name");
        json.endObject();
        if (authorizable.isUser()) {
            json.object();
            json.key("id").value("rep:userId");
            json.key("text").value("User-ID");
            json.key("inputWidget");
            json.object();
            json.key("type").value("CqTextBox");
            json.endObject();
            json.endObject();
            json.object();
            json.key("id").value("password");
            json.key("text").value("Password");
            json.endObject();
        }
        json.object();
        json.key("id").value("email");
        json.key("text").value("Email");
        json.endObject();
        json.endArray();
    }

    private void writeAuthorizables(JSONWriter writer, String key, Iterator<? extends Authorizable> auths, int limit, JSONWriterUtil.WriteMode writeMode) throws JSONException {
        int count;
        if (this.includeKey(key)) {
            writer.key(key);
            writer.array();
        }
        for (count = 0; auths.hasNext() && (limit == -1 || count < limit); ++count) {
            Authorizable auth = auths.next();
            if (!this.includeKey(key)) continue;
            writer.object();
            writer.key("id").value(auth.getID());
            JSONWriterUtil.write(writer, "name", auth.getName(), writeMode, this.xss);
            writer.key(KEY_HOME_PATH).value(auth.getHomePath());
            writer.endObject();
        }
        if (this.includeKey(key)) {
            writer.endArray();
        }
        if (this.includeKey(key + "Total")) {
            writer.key(key + "Total").value(count);
        }
    }

    private void writeModificationDates(JSONWriter writer, Authorizable authorizable) throws JSONException {
        if (this.includeKey("modification")) {
            Calendar lastMod;
            writer.key("modification").object();
            if (authorizable instanceof CQAuthorizableImpl && (lastMod = ((CQAuthorizableImpl)authorizable).getLastModified()) != null) {
                writer.key("lastModified").value(lastMod.getTimeInMillis());
                JSONWriterUtil.write(writer, "lastModifiedBy", this.getFormattedName(((CQAuthorizableImpl)authorizable).getLastModifiedBy()), JSONWriterUtil.WriteMode.BOTH, this.xss);
            }
            writer.endObject();
        }
    }

    private void writeReplication(JSONWriter writer, Authorizable authorizable) throws JSONException {
        if (this.includeKey("replication")) {
            ReplicationStatus replicationStatus = authorizable.adaptTo(ReplicationStatus.class);
            writer.key("replication").object();
            if (replicationStatus != null) {
                int maxQueuePos = -1;
                for (ReplicationQueue.Entry e : replicationStatus.getPending()) {
                    if (e.getQueuePosition() <= maxQueuePos) continue;
                    maxQueuePos = e.getQueuePosition();
                }
                writer.key("numQueued").value(maxQueuePos + 1);
                Calendar last = replicationStatus.getLastPublished();
                if (last != null) {
                    writer.key("published").value(last.getTimeInMillis());
                    JSONWriterUtil.write(writer, "publishedBy", this.getFormattedName(replicationStatus.getLastPublishedBy()), JSONWriterUtil.WriteMode.BOTH, this.xss);
                    if (replicationStatus.getLastReplicationAction() != null) {
                        writer.key("action").value(replicationStatus.getLastReplicationAction().name());
                    }
                }
            }
            writer.endObject();
        }
    }

    private String getFormattedName(String id) {
        if (id != null && this.session != null && this.pMgr != null) {
            try {
                String name;
                Profile profile = this.pMgr.getProfile(id, this.session);
                if (profile != null && profile.getFormattedName() != null && (name = profile.getFormattedName()).length() > 0) {
                    id = name;
                }
            }
            catch (RepositoryException e) {
                log.debug("Could not access Repository, when trying to access full name of {}: {}", (Object)id, (Object)e);
            }
        }
        return id;
    }

    private boolean includeKey(String key) {
        if (this.outputProps == null) {
            return true;
        }
        if (this.outputProps.contains("*")) {
            return !this.outputProps.contains(key);
        }
        return this.outputProps.contains(key);
    }

    static {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("rep:description", "aboutMe");
        tmp.put("rep:e-mail", "email");
        tmp.put("cq:first-name", "givenName");
        tmp.put("cq:last-name", "familyName");
        USER_TO_PROFILE_PROPS = tmp;
        log = LoggerFactory.getLogger(AuthorizableJSONWriter.class);
    }
}

