/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.security.util;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CqActions {
    private static Logger log = LoggerFactory.getLogger(CqActions.class);
    public static final String[] ACTIONS = new String[]{"read", "modify", "create", "delete", "acl_read", "acl_edit", "replicate"};
    private static final String CONTENT_RESTRICTION = "*/jcr:content*";
    private final Session session;
    private final Map<String, Set<Privilege>> map = new HashMap<String, Set<Privilege>>();

    public CqActions(Session session) throws RepositoryException {
        this.session = session;
        AccessControlManager acMgr = session.getAccessControlManager();
        this.map.put("read", CqActions.getPrivilegeSet("{http://www.jcp.org/jcr/1.0}read", acMgr));
        this.map.put("modify", CqActions.getPrivilegeSet(new String[]{"{http://www.jcp.org/jcr/1.0}modifyProperties", "{http://www.jcp.org/jcr/1.0}lockManagement", "{http://www.jcp.org/jcr/1.0}versionManagement"}, acMgr));
        this.map.put("create", CqActions.getPrivilegeSet(new String[]{"{http://www.jcp.org/jcr/1.0}addChildNodes", "{http://www.jcp.org/jcr/1.0}nodeTypeManagement"}, acMgr));
        this.map.put("delete", CqActions.getPrivilegeSet(new String[]{"{http://www.jcp.org/jcr/1.0}removeChildNodes", "{http://www.jcp.org/jcr/1.0}removeNode"}, acMgr));
        this.map.put("acl_read", CqActions.getPrivilegeSet("{http://www.jcp.org/jcr/1.0}readAccessControl", acMgr));
        this.map.put("acl_edit", CqActions.getPrivilegeSet("{http://www.jcp.org/jcr/1.0}modifyAccessControl", acMgr));
        try {
            this.map.put("replicate", CqActions.getPrivilegeSet("{http://www.day.com/crx/1.0}replicate", acMgr));
        }
        catch (AccessControlException e) {
            log.warn("Replicate privilege not registered");
        }
    }

    public Set<Privilege> getPrivileges(String action) {
        return this.map.get(action);
    }

    public boolean isGranted(Set<Privilege> privs, String action) {
        Set<Privilege> mappedPrivs = this.getPrivileges(action);
        return privs.containsAll(mappedPrivs);
    }

    public Collection<String> getActions(Session session, String path) throws RepositoryException {
        HashSet<Privilege> privileges = new HashSet<Privilege>();
        for (Privilege priv : session.getAccessControlManager().getPrivileges(path)) {
            if (priv.isAggregate()) {
                privileges.addAll(Arrays.asList(priv.getAggregatePrivileges()));
                continue;
            }
            privileges.add(priv);
        }
        HashSet<String> granted = new HashSet<String>();
        for (Map.Entry<String, Set<Privilege>> e : this.map.entrySet()) {
            if (!privileges.containsAll((Collection)e.getValue())) continue;
            granted.add(e.getKey());
        }
        return granted;
    }

    public Collection<String> getAllowedActions(String nodePath, Set<Principal> principals) throws RepositoryException {
        AccessControlManager acMgr = this.session.getAccessControlManager();
        HashSet<String> granted = new HashSet<String>();
        Set<Privilege> privileges = CqActions.getPrivileges(nodePath, principals, acMgr);
        for (Map.Entry<String, Set<Privilege>> e : this.map.entrySet()) {
            if (!privileges.containsAll((Collection)e.getValue())) continue;
            granted.add(e.getKey());
        }
        if (CqActions.definesContent(this.session.getNode(nodePath))) {
            String contentPath = nodePath + "/" + "jcr:content";
            if (!(!granted.contains("modify") || this.session.nodeExists(contentPath) && CqActions.getPrivileges(contentPath, principals, acMgr).containsAll(CqActions.getPrivilegeSet("rep:write", acMgr)))) {
                granted.remove("modify");
            }
        }
        return granted;
    }

    public void installActions(String nodePath, Principal principal, Map<String, Boolean> actionMap, Collection<String> inheritedAllows) throws RepositoryException {
        if (actionMap.isEmpty()) {
            return;
        }
        AccessControlManager acMgr = this.session.getAccessControlManager();
        JackrabbitAccessControlList acl = CqActions.getModifiableAcl(acMgr, nodePath);
        for (String action : actionMap.keySet()) {
            boolean isAllow = actionMap.get(action);
            Set<Privilege> privileges = this.map.get(action);
            if (privileges == null) continue;
            acl.addEntry(principal, privileges.toArray(new Privilege[privileges.size()]), isAllow);
        }
        if (CqActions.definesContent(this.session.getNode(nodePath))) {
            Map<String, Value> restrictions = null;
            for (String rName : acl.getRestrictionNames()) {
                if (!"rep:glob".equals(rName)) continue;
                Value v = this.session.getValueFactory().createValue(CONTENT_RESTRICTION, acl.getRestrictionType(rName));
                restrictions = Collections.singletonMap(rName, v);
                break;
            }
            if (restrictions == null) {
                log.warn("Cannot install special permissions node with jcr:content primary item. rep:glob restriction not supported by AC model.");
            } else {
                boolean modify;
                HashSet<Privilege> allowPrivs = new HashSet<Privilege>();
                HashSet<Privilege> denyPrivs = new HashSet<Privilege>();
                if (actionMap.containsKey("modify")) {
                    List<Privilege> contentModify = Arrays.asList(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}nodeTypeManagement"), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes"), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes"), acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode"));
                    if (actionMap.get("modify").booleanValue()) {
                        allowPrivs.addAll(contentModify);
                    } else {
                        denyPrivs.addAll(contentModify);
                    }
                    modify = actionMap.get("modify");
                } else {
                    modify = inheritedAllows.contains("modify");
                }
                if (!modify) {
                    if (actionMap.containsKey("create") && actionMap.get("create").booleanValue()) {
                        denyPrivs.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes"));
                        denyPrivs.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}nodeTypeManagement"));
                    }
                    if (actionMap.containsKey("delete") && actionMap.get("delete").booleanValue()) {
                        denyPrivs.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes"));
                        denyPrivs.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode"));
                    }
                } else {
                    if (actionMap.containsKey("create") && !actionMap.get("create").booleanValue()) {
                        allowPrivs.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes"));
                        allowPrivs.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}nodeTypeManagement"));
                    }
                    if (actionMap.containsKey("delete") && !actionMap.get("delete").booleanValue()) {
                        allowPrivs.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes"));
                        allowPrivs.add(acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode"));
                    }
                }
                if (!allowPrivs.isEmpty()) {
                    acl.addEntry(principal, allowPrivs.toArray(new Privilege[allowPrivs.size()]), true, restrictions);
                }
                if (!denyPrivs.isEmpty()) {
                    acl.addEntry(principal, denyPrivs.toArray(new Privilege[denyPrivs.size()]), false, restrictions);
                }
            }
        }
        acMgr.setPolicy(nodePath, (AccessControlPolicy)acl);
    }

    public static boolean definesContent(Node node) throws RepositoryException {
        NodeType nt = node.getPrimaryNodeType();
        for (NodeDefinition cnd : nt.getChildNodeDefinitions()) {
            if (!"jcr:content".equals(cnd.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasContentRestriction(AccessControlEntry ace) throws RepositoryException {
        if (ace instanceof JackrabbitAccessControlEntry) {
            JackrabbitAccessControlEntry jace = (JackrabbitAccessControlEntry)ace;
            for (String rName : jace.getRestrictionNames()) {
                if (!"rep:glob".equals(rName) || !CONTENT_RESTRICTION.equals(jace.getRestriction(rName).getString())) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<Privilege> getPrivileges(String path, Set<Principal> principals, AccessControlManager acMgr) throws RepositoryException, AccessDeniedException {
        HashSet<Privilege> privileges = new HashSet<Privilege>();
        Privilege[] privs = principals == null ? acMgr.getPrivileges(path) : ((JackrabbitAccessControlManager)acMgr).getPrivileges(path, principals);
        for (Privilege priv : privs) {
            if (priv.isAggregate()) {
                privileges.addAll(Arrays.asList(priv.getAggregatePrivileges()));
                continue;
            }
            privileges.add(priv);
        }
        return privileges;
    }

    private static Set<Privilege> getPrivilegeSet(String privName, AccessControlManager acMgr) throws RepositoryException {
        Privilege p = acMgr.privilegeFromName(privName);
        Set<Privilege> privileges = p.isAggregate() ? new HashSet<Privilege>(Arrays.asList(p.getAggregatePrivileges())) : Collections.singleton(p);
        return privileges;
    }

    private static Set<Privilege> getPrivilegeSet(String[] privNames, AccessControlManager acMgr) throws RepositoryException {
        HashSet<Privilege> privileges = new HashSet<Privilege>(privNames.length);
        for (String name : privNames) {
            Privilege p = acMgr.privilegeFromName(name);
            if (p.isAggregate()) {
                privileges.addAll(Arrays.asList(p.getAggregatePrivileges()));
                continue;
            }
            privileges.add(p);
        }
        return privileges;
    }

    private static JackrabbitAccessControlList getModifiableAcl(AccessControlManager acMgr, String path) throws RepositoryException, AccessDeniedException {
        AccessControlPolicy[] existing;
        for (AccessControlPolicy p : existing = acMgr.getPolicies(path)) {
            if (!(p instanceof JackrabbitAccessControlList)) continue;
            return (JackrabbitAccessControlList)p;
        }
        AccessControlPolicyIterator it = acMgr.getApplicablePolicies(path);
        while (it.hasNext()) {
            AccessControlPolicy p = it.nextAccessControlPolicy();
            if (!(p instanceof JackrabbitAccessControlList)) continue;
            return (JackrabbitAccessControlList)p;
        }
        throw new AccessControlException("No modifiable ACL at " + path);
    }
}

