/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.shindig.gadgets;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Component(metatype=false)
@Service(value={CQGadgetsConfigManager.class})
@Properties(value={@Property(name="service.description", value={"Manages the persistence of gadget related data"})})
public class CQGadgetsConfigManager {
    public static final String PROPERTY_ID = "gadgetId";
    private static final String PATH_GADGETS = "personalization/gadgets";
    private static final Logger log = LoggerFactory.getLogger(CQGadgetsConfigManager.class);

    public boolean hasGadget(String gadgetId, Resource resource) throws RepositoryException {
        return this.getGadgetResource(gadgetId, resource) != null;
    }

    public List<String> getGadgetList(Resource resource) throws RepositoryException {
        ArrayList<String> res = new ArrayList<String>();
        Iterator<Resource> itr = this.getGadgetResources(resource);
        while (itr.hasNext()) {
            ValueMap map = itr.next().adaptTo(ValueMap.class);
            String id = map.get(PROPERTY_ID, null);
            if (id == null) continue;
            res.add(id);
        }
        return res;
    }

    public Resource getGadgetConfig(String id, Resource resource) throws RepositoryException {
        if (this.hasGadget(id, resource)) {
            return this.getGadgetResource(id, resource);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeGadget(String gadgetId, Resource resource) throws RepositoryException {
        if (this.hasGadget(gadgetId, resource)) {
            Resource gadgetResource = this.getGadgetResource(gadgetId, resource);
            Node node = gadgetResource.adaptTo(Node.class);
            if (node == null) {
                return false;
            }
            Session session = node.getSession();
            log.trace("Found list entry to remove for {} with gadget {} on {}", new Object[]{session.getUserID(), gadgetId, resource.getPath()});
            try {
                session.refresh(true);
                node.remove();
                session.save();
                log.debug("Removed list entry to remove for {} with gadget {} on {}", new Object[]{session.getUserID(), gadgetId, resource.getPath()});
                boolean bl = true;
                return bl;
            }
            finally {
                if (session.hasPendingChanges()) {
                    session.refresh(false);
                }
            }
        }
        return false;
    }

    public boolean addGadget(String gadgetId, Resource resource) throws RepositoryException {
        UserProperties properties;
        if (!this.hasGadget(gadgetId, resource) && (properties = this.getListRoot(resource)) != null) {
            log.trace("Start adding gadget {} for {} to {}", new Object[]{gadgetId, properties.getNode().getSession().getUserID(), resource.getPath()});
            Iterator<Resource> children = this.getGadgetResources(resource);
            int max = 0;
            while (children.hasNext()) {
                try {
                    int curr = Integer.valueOf(Text.getName(children.next().getPath()));
                    max = Math.max(max, curr) + 1;
                }
                catch (NumberFormatException ignored) {}
            }
            Node node = properties.getNode();
            node.setProperty(max + "/" + PROPERTY_ID, gadgetId);
            node.getSession().save();
            log.debug("Added gadget {} for {} to {}", new Object[]{gadgetId, properties.getNode().getSession().getUserID(), resource.getPath()});
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) throws RepositoryException {
        block22: {
            SlingRepository repos = null;
            ServiceReference ref = context.getBundleContext().getServiceReference(SlingRepository.class.getName());
            if (ref != null) {
                repos = (SlingRepository)context.getBundleContext().getService(ref);
            }
            if (repos == null) {
                log.debug("Check for update failed: no repository available: check next start");
            } else {
                Session admin = null;
                try {
                    admin = repos.loginAdministrative(repos.getDefaultWorkspace());
                    QueryManager qm = admin.getWorkspace().getQueryManager();
                    if (qm == null) {
                        log.debug("Check for update failed: no QueryManager available for {}", (Object)repos.getDefaultWorkspace());
                        break block22;
                    }
                    if (admin.itemExists("/var/upgrade/status/Cq53GadgetUpgrade")) {
                        log.debug("Gadget Upgrade already performed");
                        break block22;
                    }
                    Node status = JcrUtil.createPath("/var/upgrade/status", "nt:unstructured", admin);
                    status.setProperty("Cq53GadgetUpgrade", Calendar.getInstance());
                    admin.save();
                    try {
                        Query query = qm.createQuery("/jcr:root/home/users//*[collaboration/gadgets/config/@jcr:primaryType]", "xpath");
                        NodeIterator res = query.execute().getNodes();
                        if (res.hasNext()) {
                            log.debug("Found pre CQ 5.3 config -> need gadgets update");
                            Query pageQuery = qm.createQuery("/jcr:root/content//*[@sling:resourceType='cq/personalization/components/mygadgets']", "xpath");
                            NodeIterator pages = pageQuery.execute().getNodes();
                            String identifier = null;
                            while (pages.hasNext()) {
                                Node cand = pages.nextNode();
                                if (!cand.getPath().contains("jcr:content")) continue;
                                while (!(cand = cand.getParent()).hasNode("jcr:content")) {
                                }
                                identifier = cand.getIdentifier();
                                log.debug("Found Page using gadget component: updated for this page {}", (Object)cand.getPath());
                                break;
                            }
                            if (identifier != null) {
                                int cnt = 0;
                                while (res.hasNext()) {
                                    Node auth = res.nextNode();
                                    log.debug("Start updating Users {} gadgets:", (Object)auth.getPath());
                                    Node dest = JcrUtil.createPath(auth.getPath() + "/preferences/" + PATH_GADGETS + "/" + identifier, "nt:unstructured", admin);
                                    NodeIterator configs = auth.getNode("collaboration/gadgets/config").getNodes();
                                    while (configs.hasNext()) {
                                        Node configNode = configs.nextNode();
                                        String src = configNode.getPath();
                                        String dst = dest.getPath() + "/" + configNode.getName();
                                        if (admin.nodeExists(dst)) {
                                            log.debug("Skip addition of existing node at {}", (Object)dst);
                                        } else {
                                            admin.move(src, dst);
                                        }
                                        ++cnt;
                                        log.debug("Move Gadget config from {} to {}:", (Object)src, (Object)dest.getPath());
                                    }
                                    if (cnt <= 1024) continue;
                                    log.debug("Reached threshold, save at least 1024 moves");
                                    admin.refresh(true);
                                    admin.save();
                                    cnt = 0;
                                }
                                admin.refresh(true);
                                admin.save();
                                log.debug("Migrated Gadget configurations");
                            }
                        }
                    }
                    catch (RepositoryException e) {
                        log.error("Failed to run update on gadgets, try next start: {}", (Throwable)e);
                        log.debug("Cause:", (Throwable)e);
                        if (admin.hasPendingChanges()) {
                            admin.refresh(false);
                        }
                        admin.getItem("/var/upgrade/status/Cq53GadgetUpgrade").remove();
                        admin.save();
                    }
                }
                catch (RepositoryException e) {
                    log.error("Failed to check if update is necessary {}: check next start", (Throwable)e);
                }
                finally {
                    if (admin != null) {
                        admin.logout();
                    }
                }
            }
        }
    }

    private UserProperties getListRoot(Resource resource) throws RepositoryException {
        ResourceResolver resolver = resource.getResourceResolver();
        UserPropertiesManager userPropertiesManager = resolver.adaptTo(UserPropertiesManager.class);
        Node node = resource.adaptTo(Node.class);
        String id = node != null ? node.getIdentifier() : "defaults";
        StringBuilder settingsRoot = new StringBuilder();
        settingsRoot.append("preferences");
        settingsRoot.append(PATH_GADGETS).append("/").append(id);
        String rootPath = settingsRoot.toString();
        return userPropertiesManager.getUserProperties(resolver.getUserID(), rootPath);
    }

    private Iterator<Resource> getGadgetResources(Resource resource) throws RepositoryException {
        try {
            UserProperties properties = this.getListRoot(resource);
            ResourceResolver resolver = resource.getResourceResolver();
            Resource listResource = resolver.getResource(properties.getNode().getPath());
            if (listResource != null) {
                return resolver.listChildren(listResource);
            }
        }
        catch (AccessDeniedException e) {
            log.debug("Failed to create gadget list root for {}: insufficient privileges", (Object)resource.getResourceResolver().getUserID());
        }
        catch (RepositoryException e1) {
            log.error("Failed to create gadget list root: {}", (Throwable)e1);
            log.debug("Cause: {}", (Throwable)e1);
        }
        return Collections.emptySet().iterator();
    }

    private Resource getGadgetResource(String gadgetId, Resource resource) throws RepositoryException {
        Iterator<Resource> itr = this.getGadgetResources(resource);
        while (itr.hasNext()) {
            Resource listRes = itr.next();
            Node node = listRes.adaptTo(Node.class);
            if (!node.hasProperty(PROPERTY_ID) || !gadgetId.equals(node.getProperty(PROPERTY_ID).getString())) continue;
            return listRes;
        }
        return null;
    }
}

