/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.api;

import com.day.cq.wcm.api.PageEvent;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.sling.event.EventPropertiesMap;
import org.osgi.service.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PageModification
implements Serializable {
    private static final String PROPERTY_CHANGES = "changes";
    private static final String PROPERTY_VERSION_ID = "versionId";
    private static final String PROPERTY_USER_ID = "userId";
    private static final String PROPERTY_PATH = "path";
    private static final String PROPERTY_DESTINATION = "destination";
    private static final String PROPERTY_ABOVE = "above";
    private static final String PROPERTY_MODIFIED_DATE = "modifiedDate";
    private static final String PROPERTY_TYPE = "type";
    private final String path;
    private final String destination;
    private final String above;
    private final ModificationType type;
    private final String versionId;
    private final String userId;
    private final Date modificationDate;
    private final Set<String> changes;

    public static PageModification created(String path, String above, String userId) {
        return new PageModification(ModificationType.CREATED, path, null, null, above, userId, null, null);
    }

    public static PageModification modified(String path, String vid, String userId, Set<String> changes) {
        return new PageModification(ModificationType.MODIFIED, path, vid, null, null, userId, null, changes);
    }

    public static PageModification moved(String path, String destination, String above, String userId) {
        return new PageModification(ModificationType.MOVED, path, null, destination, above, userId, null, null);
    }

    public static PageModification deleted(String path, String userId) {
        return new PageModification(ModificationType.DELETED, path, null, null, null, userId, null, null);
    }

    public static PageModification versionCreated(String path, String vid, String userId) {
        return new PageModification(ModificationType.VERSION_CREATED, path, vid, null, null, userId, null, null);
    }

    public static PageModification pageRestored(String path, String vid, String userId) {
        return new PageModification(ModificationType.RESTORED, path, vid, null, null, userId, null, null);
    }

    public static PageModification pageValid(String path, long time) {
        return new PageModification(ModificationType.VALID, path, null, null, null, null, new Date(time), null);
    }

    public static PageModification pageInvalid(String path, long time) {
        return new PageModification(ModificationType.INVALID, path, null, null, null, null, new Date(time), null);
    }

    public static PageModification rolledout(String path, String userId) {
        return new PageModification(ModificationType.ROLLEDOUT, path, null, null, null, userId, null, null);
    }

    private PageModification(ModificationType type, String path, String versionid, String destination, String above, String userId, Date md, Set<String> changes) {
        this.type = type;
        this.path = path;
        this.versionId = versionid;
        this.destination = destination;
        this.above = above;
        this.userId = userId == null ? "admin" : userId;
        this.modificationDate = md == null ? new Date() : md;
        this.changes = changes;
    }

    public String getPath() {
        return this.path;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getAbove() {
        return this.above;
    }

    public ModificationType getType() {
        return this.type;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public Set<String> getModificationPaths() {
        return this.changes;
    }

    public final boolean equals(Object o) {
        if (o instanceof PageModification) {
            PageModification other = (PageModification)o;
            return other.path.equals(this.path) && other.destination.equals(this.destination) && other.type == this.type;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.path.hashCode() ^ this.type.hashCode();
        if (this.destination != null) {
            hashCode ^= this.destination.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("page ");
        switch (this.type) {
            case CREATED: {
                b.append("created");
                break;
            }
            case MODIFIED: {
                b.append("modified");
                break;
            }
            case MOVED: {
                b.append("moved");
                break;
            }
            case DELETED: {
                b.append("deleted");
                break;
            }
            case VERSION_CREATED: {
                b.append("version created");
                break;
            }
            case RESTORED: {
                b.append("version restored");
                break;
            }
            case ROLLEDOUT: {
                b.append("rolled out");
                break;
            }
            case VALID: {
                b.append("valid");
                break;
            }
            case INVALID: {
                b.append("invalid");
            }
        }
        b.append(": ");
        b.append(this.path);
        if (this.destination != null) {
            b.append(" --> ");
            b.append(this.destination);
        }
        if (this.above != null) {
            b.append(", above: ");
            b.append(this.above);
        }
        if (this.versionId != null) {
            b.append(", vid: ");
            b.append(this.versionId);
        }
        if (this.userId != null) {
            b.append(", userId: ");
            b.append(this.userId);
        }
        return b.toString();
    }

    public EventPropertiesMap getEventProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(PROPERTY_TYPE, this.type.toString());
        properties.put(PROPERTY_MODIFIED_DATE, this.modificationDate);
        if (this.above != null) {
            properties.put(PROPERTY_ABOVE, this.above);
        }
        if (this.destination != null) {
            properties.put(PROPERTY_DESTINATION, this.destination);
        }
        if (this.path != null) {
            properties.put(PROPERTY_PATH, this.path);
        }
        if (this.userId != null) {
            properties.put(PROPERTY_USER_ID, this.userId);
        }
        if (this.versionId != null) {
            properties.put(PROPERTY_VERSION_ID, this.versionId);
        }
        if (this.changes != null) {
            properties.put(PROPERTY_CHANGES, this.changes);
        }
        return new EventPropertiesMap(properties);
    }

    public static PageModification fromEventProperties(EventPropertiesMap props) {
        return new PageModification(ModificationType.fromName((String)props.get(PROPERTY_TYPE)), (String)props.get(PROPERTY_PATH), (String)props.get(PROPERTY_VERSION_ID), (String)props.get(PROPERTY_DESTINATION), (String)props.get(PROPERTY_ABOVE), (String)props.get(PROPERTY_USER_ID), (Date)props.get(PROPERTY_MODIFIED_DATE), (Set)props.get(PROPERTY_CHANGES));
    }

    public Event toEvent() {
        return new PageEvent(this).toEvent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModificationType {
        CREATED("PageCreated"),
        MODIFIED("PageModified"),
        MOVED("PageMoved"),
        DELETED("PageDeleted"),
        VERSION_CREATED("VersionCreated"),
        RESTORED("PageRestored"),
        ROLLEDOUT("PageRolledOut"),
        VALID("PageValid"),
        INVALID("PageInvalid");

        private final String name;

        private ModificationType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static ModificationType fromName(String n) {
            for (ModificationType m : ModificationType.values()) {
                if (!m.toString().equals(n)) continue;
                return m;
            }
            throw new IllegalArgumentException("Unknown modification type: " + n);
        }
    }
}

