/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.api.components;

import com.day.cq.wcm.api.components.Toolbar;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

public class JcrToolbarItem
implements Toolbar.Item {
    private final Node node;

    public JcrToolbarItem(Node node) throws RepositoryException {
        this.node = node;
    }

    public void write(JSONWriter writer) throws JSONException {
        try {
            this.dump(writer, this.node);
        }
        catch (RepositoryException e) {
            throw new JSONException("Error while writing JSON.", e);
        }
    }

    private void dump(JSONWriter out, Node node) throws JSONException, RepositoryException {
        out.object();
        out.key("name");
        out.value(node.getName());
        PropertyIterator pIter = node.getProperties();
        while (pIter.hasNext()) {
            Property p = pIter.nextProperty();
            if (p.getType() == 2) {
                out.key("*" + p.getName());
            } else {
                out.key(p.getName());
            }
            if (p.getDefinition().isMultiple()) {
                Value[] vs;
                out.array();
                for (Value v : vs = p.getValues()) {
                    this.dump(out, v);
                }
                out.endArray();
                continue;
            }
            this.dump(out, p.getValue());
        }
        NodeIterator nIter = node.getNodes();
        while (nIter.hasNext()) {
            Node child = nIter.nextNode();
            out.key(child.getName());
            this.dump(out, child);
        }
        out.endObject();
    }

    private void dump(JSONWriter out, Value v) throws RepositoryException, JSONException {
        if (v.getType() == 2) {
            out.value(0L);
        } else if (v.getType() == 5) {
            SimpleDateFormat fmt = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z", Locale.US);
            out.value(fmt.format(v.getDate().getTime()));
        } else {
            out.value(v.getString());
        }
    }
}

