/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

public class GlobPattern {
    private final String pattern;
    private final String handlePattern;

    public GlobPattern(String pattern, boolean isHandle) {
        this.pattern = pattern;
        this.handlePattern = isHandle && !GlobPattern.containsWildcards(pattern) ? (pattern.equals("/") ? "/" : pattern + '/') : null;
    }

    public GlobPattern(String pattern) {
        this(pattern, false);
    }

    public final boolean matches(String s) {
        if (this.handlePattern != null) {
            return this.pattern.equals(s) || s.startsWith(this.handlePattern);
        }
        return GlobPattern.recurseMatchPattern(this.pattern, s, 0, 0);
    }

    public static boolean matches(String pattern, String s) {
        return GlobPattern.recurseMatchPattern(pattern, s, 0, 0);
    }

    public static boolean matches(String pattern, String s, boolean isHandle) {
        if (isHandle && !GlobPattern.containsWildcards(pattern)) {
            return pattern.equals(s) || s.startsWith(pattern + '/');
        }
        return GlobPattern.matches(pattern, s);
    }

    public boolean shellMatches(String s) {
        return this.shellMatches(s, '/');
    }

    public boolean shellMatches(String s, char c) {
        int len;
        if (this.pattern.equals("*")) {
            return true;
        }
        int sc = 0;
        for (len = s.length() - 1; len >= 0; --len) {
            if (s.charAt(len) != c) continue;
            ++sc;
        }
        for (len = this.pattern.length() - 1; len >= 0; --len) {
            if (this.pattern.charAt(len) != c) continue;
            --sc;
        }
        return sc == 0 && this.matches(s);
    }

    public static boolean containsWildcards(String s) {
        return GlobPattern.indexOfWildcard(s) >= 0;
    }

    public static int indexOfWildcard(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if ("*?[]".indexOf(s.charAt(i)) == -1) continue;
            return i;
        }
        return -1;
    }

    private static boolean recurseMatchPattern(String pattern, String s, int sIdx, int pIdx) {
        int pLen = pattern.length();
        int sLen = s.length();
        while (pIdx < pLen) {
            if (sIdx >= sLen && pattern.charAt(pIdx) != '*') {
                return false;
            }
            if (pattern.charAt(pIdx) == '*') {
                if (++pIdx >= pLen) {
                    return true;
                }
                while (true) {
                    if (GlobPattern.recurseMatchPattern(pattern, s, sIdx, pIdx)) {
                        return true;
                    }
                    if (sIdx >= sLen) {
                        return false;
                    }
                    ++sIdx;
                }
            }
            if (pattern.charAt(pIdx) == '?') {
                ++pIdx;
                ++sIdx;
                continue;
            }
            if (pattern.charAt(pIdx) == '[') {
                ++pIdx;
                while (true) {
                    if (pIdx >= pLen || pattern.charAt(pIdx) == ']') {
                        return false;
                    }
                    if (pattern.charAt(pIdx) == s.charAt(sIdx)) break;
                    if (pIdx < pLen - 1 && pattern.charAt(pIdx + 1) == '-') {
                        if (pIdx >= pLen - 2) {
                            return false;
                        }
                        char chStr = s.charAt(sIdx);
                        char chPtn = pattern.charAt(pIdx);
                        char chPtn2 = pattern.charAt(pIdx + 2);
                        if (chPtn <= chStr && chPtn2 >= chStr || chPtn >= chStr && chPtn2 <= chStr) break;
                        pIdx += 2;
                    }
                    ++pIdx;
                }
                while (pattern.charAt(pIdx) != ']') {
                    if (pIdx >= pLen) {
                        --pIdx;
                        break;
                    }
                    ++pIdx;
                }
                ++pIdx;
                ++sIdx;
                continue;
            }
            if (pattern.charAt(pIdx) == '\\' && ++pIdx >= pLen) {
                return false;
            }
            if (pIdx < pLen && sIdx < sLen && pattern.charAt(pIdx) != s.charAt(sIdx)) {
                return false;
            }
            ++pIdx;
            ++sIdx;
        }
        return sIdx >= sLen;
    }

    public String toString() {
        return this.pattern;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GlobPattern) {
            GlobPattern other = (GlobPattern)obj;
            return this.pattern.equals(other.pattern) && this.isHandlePattern() == other.isHandlePattern();
        }
        return false;
    }

    public int hashCode() {
        return this.pattern.hashCode() + (this.isHandlePattern() ? 1 : 0);
    }

    private boolean isHandlePattern() {
        return this.handlePattern != null;
    }
}

