/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter;

import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.designimporter.CanvasPageManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Component
public class CanvasPageActivationHandler
implements EventListener {
    @Reference
    ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Replicator replicator;
    @Reference
    private CanvasPageManager canvasPageManager;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ResourceResolver resolver;
    private static final String LAST_REPLICATION_ACTION = "cq:lastReplicationAction";

    @Activate
    protected void activate(ComponentContext context) throws Exception {
        this.resolver = this.resourceResolverFactory.getAdministrativeResourceResolver(Collections.<String, Object>emptyMap());
        Session session = this.resolver.adaptTo(Session.class);
        session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 20, "/content/campaigns", true, null, new String[]{"cq:PageContent"}, true);
    }

    public void onEvent(EventIterator events) {
        while (events.hasNext()) {
            Event evt = events.nextEvent();
            if (evt.getType() != 4 && evt.getType() != 16) continue;
            try {
                String path = evt.getPath();
                if (!path.endsWith(LAST_REPLICATION_ACTION) || !this.canvasPageManager.isCanvasPage(this.resolver, path = path.substring(0, path.lastIndexOf("jcr:content")))) continue;
                Node node = this.resolver.resolve(path).adaptTo(Node.class);
                Node contentNode = node.getNode("jcr:content");
                String replicationAction = contentNode.getProperty(LAST_REPLICATION_ACTION).getValue().getString();
                if (this.canvasPageManager.isDesktopCanvasPage(this.resolver, path)) {
                    this.replicateCanvasPage(path, replicationAction, (Boolean)false);
                    Page mobileCanvasPage = this.canvasPageManager.getMobileVersion(this.resolver, path);
                    this.replicateCanvasPage(mobileCanvasPage, replicationAction, (Boolean)true);
                    continue;
                }
                Page mobilePage = this.resolver.resolve(path).adaptTo(Page.class);
                this.replicateCanvasPage(mobilePage, replicationAction, (Boolean)false);
            }
            catch (RepositoryException e) {
                this.log.error("Repository exception encountered", (Throwable)e);
            }
        }
    }

    private void replicateCanvasPage(Page page, String replicationAction, Boolean replicateSelf) {
        if (page != null) {
            this.replicateCanvasPage(page.getPath(), replicationAction, replicateSelf);
        }
    }

    private void replicateCanvasPage(String path, String replicationAction, Boolean replicateSelf) {
        Node node = this.resolver.resolve(path).adaptTo(Node.class);
        ReplicationActionType action = ReplicationActionType.fromName(replicationAction);
        if (action != null && this.replicator != null) {
            ReplicationOptions opts = new ReplicationOptions();
            boolean isMobilePage = this.canvasPageManager.isMobileCanvasPage(this.resolver, path);
            List<String> dependentPaths = this.getCanvasPageDependentPaths(this.resolver, path, isMobilePage);
            if (replicateSelf.booleanValue()) {
                dependentPaths.add(path);
            }
            if (dependentPaths.size() > 0) {
                Collections.sort(dependentPaths, new StringSortComparator());
                for (String depPath : dependentPaths) {
                    try {
                        this.log.info("Replication started for " + depPath);
                        this.replicator.replicate(node.getSession(), action, depPath, opts);
                    }
                    catch (AccessDeniedException ade) {
                        this.log.error("Error: No rights to replicate. Request for de/activation got issued for " + depPath);
                    }
                    catch (Throwable e) {
                        this.log.error("Error during replication: " + e.getMessage(), e);
                    }
                }
            }
        }
    }

    private List<String> getCanvasPageDependentPaths(ResourceResolver resolver, String path, Boolean isMobilePage) {
        ArrayList<String> depPaths = new ArrayList<String>();
        if (!isMobilePage.booleanValue()) {
            depPaths.addAll(this.getDesignPaths(path));
        }
        depPaths.addAll(this.getCanvasPaths(path));
        depPaths.addAll(this.getMboxPaths(path));
        return depPaths;
    }

    private List<String> getDesignPaths(String path) {
        ArrayList<String> designPaths = new ArrayList<String>();
        try {
            Node node = this.resolver.getResource(path).adaptTo(Node.class);
            Node contentNode = node.getNode("jcr:content");
            Property designPath = contentNode.getProperty("cq:designPath");
            String designPathVal = designPath.getValue().getString();
            designPaths.add(designPathVal);
            designPaths.addAll(this.getAllChildNodes(this.resolver, designPathVal));
        }
        catch (RepositoryException e) {
            this.log.error("An error occured while trying to obtain the dependent paths for the canvas page at - " + path, (Throwable)e);
        }
        return designPaths;
    }

    private List<String> getMboxPaths(String path) {
        ArrayList<String> mboxPaths = new ArrayList<String>();
        try {
            Node node = this.resolver.getResource(path).adaptTo(Node.class);
            Node contentNode = node.getNode("jcr:content");
            Node canvasNode = contentNode.getNode("canvas");
            if (canvasNode != null) {
                String canvasPageNodeName = canvasNode.getProperty("sling:resourceType").getValue().getString();
                String canvasPageResTypeValue = "/apps/" + canvasPageNodeName;
                Node canvasPageNode = this.resolver.getResource(canvasPageResTypeValue).adaptTo(Node.class);
                String nodeName = canvasPageNode.getName();
                Node parent = canvasPageNode.getParent().getParent();
                if (parent.hasNode("mbox")) {
                    Node mboxNode = parent.getNode("mbox");
                    int indexOf = nodeName.lastIndexOf("-");
                    String prefixForMboxFile = nodeName.substring(0, indexOf);
                    NodeIterator nodeIterator = mboxNode.getNodes();
                    while (nodeIterator.hasNext()) {
                        Node childNode = (Node)nodeIterator.next();
                        if (!childNode.getName().startsWith(prefixForMboxFile)) continue;
                        mboxPaths.add(childNode.getPath());
                        mboxPaths.addAll(this.getAllChildNodes(this.resolver, childNode.getPath()));
                    }
                }
            }
        }
        catch (RepositoryException e) {
            this.log.error("An error occured while trying to obtain the dependent paths for the mbox at - " + path, (Throwable)e);
        }
        return mboxPaths;
    }

    private List<String> getCanvasPaths(String path) {
        ArrayList<String> canvasPaths = new ArrayList<String>();
        try {
            Node node = this.resolver.getResource(path).adaptTo(Node.class);
            Node contentNode = node.getNode("jcr:content");
            Node canvasNode = contentNode.getNode("canvas");
            if (canvasNode != null) {
                String resTypeValue = "/apps/" + canvasNode.getProperty("sling:resourceType").getValue().getString();
                canvasPaths.add(resTypeValue);
                canvasPaths.addAll(this.getAllChildNodes(this.resolver, resTypeValue));
            }
        }
        catch (RepositoryException e) {
            this.log.error("An error occured while trying to obtain the dependent paths for the canvas page at - " + path, (Throwable)e);
        }
        return canvasPaths;
    }

    private List<String> getAllChildNodes(ResourceResolver resolver, String path) throws RepositoryException {
        if (resolver.getResource(path) != null) {
            Node node = resolver.getResource(path).adaptTo(Node.class);
            if (node == null) {
                return null;
            }
            ArrayList<String> childPaths = new ArrayList<String>();
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                String childPath = ((Node)iter.next()).getPath();
                if (childPath.endsWith("jcr:content")) continue;
                childPaths.add(childPath);
                childPaths.addAll(this.getAllChildNodes(resolver, childPath));
            }
            return childPaths;
        }
        return null;
    }

    @Deactivate
    protected void deactivate(ComponentContext context) throws Exception {
        if (this.resolver != null) {
            this.resolver.close();
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindCanvasPageManager(CanvasPageManager canvasPageManager) {
        this.canvasPageManager = canvasPageManager;
    }

    protected void unbindCanvasPageManager(CanvasPageManager canvasPageManager) {
        if (this.canvasPageManager == canvasPageManager) {
            this.canvasPageManager = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StringSortComparator
    implements Comparator<String> {
        StringSortComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 != null && o2 != null) {
                if (o1.endsWith("js.txt") || o1.endsWith("css.txt")) {
                    return 1;
                }
                if (o1.endsWith("clientlibs")) {
                    return 1;
                }
            }
            if (o1 != null) {
                return -1;
            }
            return 1;
        }
    }
}

