/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter;

import com.day.cq.replication.AccessDeniedException;
import com.day.cq.replication.DefaultAggregateHandler;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.replication.Replicator;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.PageManagerFactory;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.designimporter.CanvasPageManager;
import com.day.cq.wcm.designimporter.DesignImportException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component
@Service(value={CanvasPageManager.class})
public class CanvasPageManagerImpl
implements CanvasPageManager {
    @Reference
    private Replicator replicator;
    @Reference
    private PageManagerFactory pageManagerFactory;
    private static final Logger log = LoggerFactory.getLogger(CanvasPageManagerImpl.class);
    private static final String CANVAS_PAGE_RESOURCETYPE = "wcm/designimporter/components/canvaspage";
    private static final String MOBILE_CANVAS_PAGE_RESOURCETYPE = "wcm/designimporter/components/mobilecanvaspage";

    private PageManager getPageManager(ResourceResolver resolver) {
        return this.pageManagerFactory.getPageManager(resolver);
    }

    public void deleteCanvasPage(Page page) throws DesignImportException {
        if (page != null) {
            this.deleteCanvasPage(page.adaptTo(Resource.class));
        }
    }

    public void deleteCanvasPage(Resource resource) throws DesignImportException {
        if (resource == null) {
            throw new IllegalArgumentException("Canvas Page resource to be deleted must not be Empty");
        }
        if (this.isCanvasPage(resource)) {
            this.deleteCanvasPageArtifacts(resource);
            PageManager pageManager = this.getPageManager(resource.getResourceResolver());
            try {
                pageManager.delete(resource, false);
            }
            catch (WCMException e) {
                throw new DesignImportException(e);
            }
        }
    }

    public void deleteCanvasPageArtifacts(Page page) throws DesignImportException {
        if (page != null) {
            this.deleteCanvasPageArtifacts(page.adaptTo(Resource.class));
        }
    }

    public void deleteCanvasPageArtifacts(Resource resource) throws DesignImportException {
        if (resource == null) {
            throw new IllegalArgumentException("Canvas Page resource to be deleted must not be Empty");
        }
        if (this.isCanvasPage(resource)) {
            if (this.isDesktopCanvasPage(resource)) {
                this.deleteCanvasNode(resource);
                this.deleteDesignNode(resource);
                Page mobilePage = this.getMobileVersion(resource);
                this.deleteCanvasPageArtifacts(mobilePage);
            } else {
                this.deleteCanvasNode(resource);
            }
        }
    }

    private void deleteCanvasNode(Resource resource) throws DesignImportException {
        Resource canvasResource = resource.getChild("jcr:content/canvas");
        if (canvasResource != null) {
            String canvasResourcetype = canvasResource.getResourceType();
            Resource canvasComponentResource = resource.getResourceResolver().resolve("/apps/" + canvasResourcetype);
            this.deleteResource(canvasComponentResource);
        }
    }

    private void deleteDesignNode(Resource resource) throws DesignImportException {
        String pagePath = resource.getPath();
        String designPath = "/etc/designs/canvaspage" + pagePath;
        Resource designResource = resource.getResourceResolver().resolve(designPath);
        if (designResource != null && !(designResource instanceof NonExistingResource)) {
            this.deleteResource(designResource);
        }
    }

    private void deleteResource(Resource resource) throws DesignImportException {
        try {
            ReplicationStatus rs;
            Node node = resource.getResourceResolver().getResource(resource.getPath()).adaptTo(Node.class);
            Session session = node.getSession();
            CanvasPageAggregateHandler handler = new CanvasPageAggregateHandler();
            ReplicationStatus replicationStatus = rs = resource == null ? null : resource.adaptTo(ReplicationStatus.class);
            if (rs != null && rs.getLastReplicationAction() == ReplicationActionType.ACTIVATE && this.replicator != null) {
                try {
                    ReplicationOptions opts = new ReplicationOptions();
                    opts.setAggregateHandler(handler);
                    this.replicator.replicate(session, ReplicationActionType.DELETE, resource.getPath(), opts);
                }
                catch (AccessDeniedException e) {
                    log.error("Not enough permissions to delete page", (Throwable)e);
                    throw new DesignImportException("Not enough permissions to delete page", e);
                }
                catch (ReplicationException e) {
                    log.error("Error during delete replication of " + resource.getPath(), (Throwable)e);
                    throw new DesignImportException("Error during delete replication of " + resource.getPath(), e);
                }
            }
            if (handler.numDeleted == 0) {
                node.remove();
                session.save();
            }
        }
        catch (RepositoryException e) {
            log.error("Error while deleting: " + resource.getPath(), (Throwable)e);
            throw new DesignImportException("Error while deleting: " + resource.getPath(), e);
        }
    }

    public Page getMobileVersion(Resource canvasPageResource) {
        if (canvasPageResource != null) {
            Iterator<Resource> iter = canvasPageResource.listChildren();
            while (iter.hasNext()) {
                Resource resource = iter.next();
                if (!this.isMobileCanvasPage(resource.getResourceResolver(), resource.getPath())) continue;
                return this.getPageManager(resource.getResourceResolver()).getPage(resource.getPath());
            }
        }
        return null;
    }

    public Page getDesktopVersion(Resource mobileCanvasPageResource) {
        if (mobileCanvasPageResource != null && mobileCanvasPageResource.getParent() != null) {
            ResourceResolver resolver = mobileCanvasPageResource.getResourceResolver();
            Resource desktopResource = mobileCanvasPageResource.getParent();
            if (this.isDesktopCanvasPage(desktopResource)) {
                return this.getPageManager(resolver).getPage(desktopResource.getPath());
            }
        }
        return null;
    }

    public Page getMobileVersion(Page canvasPage) {
        if (canvasPage != null) {
            return this.getMobileVersion(canvasPage.adaptTo(Resource.class));
        }
        return null;
    }

    public Page getDesktopVersion(Page mobileCanvasPage) {
        if (mobileCanvasPage != null) {
            return this.getDesktopVersion(mobileCanvasPage.adaptTo(Resource.class));
        }
        return null;
    }

    public Page getMobileVersion(ResourceResolver resolver, String canvasPagePath) {
        Resource resource = resolver.getResource(canvasPagePath);
        if (resource != null) {
            return this.getMobileVersion(resource);
        }
        return null;
    }

    public Page getDesktopVersion(ResourceResolver resolver, String mobileCanvasPagePath) {
        Resource resource = resolver.getResource(mobileCanvasPagePath);
        if (resource != null) {
            return this.getDesktopVersion(resource);
        }
        return null;
    }

    public Page getCanvasPage(ResourceResolver resolver, String path) {
        if (this.isCanvasPage(resolver, path)) {
            return this.getPageManager(resolver).getPage(path);
        }
        return null;
    }

    public boolean isCanvasPage(ResourceResolver resolver, String path) {
        return this.isDesktopCanvasPage(resolver, path) || this.isMobileCanvasPage(resolver, path);
    }

    public boolean isCanvasPage(Page page) {
        if (page != null) {
            Resource resource = page.adaptTo(Resource.class);
            return this.isCanvasPage(resource);
        }
        return false;
    }

    public boolean isCanvasPage(Resource resource) {
        if (resource != null) {
            return this.isCanvasPage(resource.getResourceResolver(), resource.getPath());
        }
        return false;
    }

    public boolean isMobileCanvasPage(ResourceResolver resolver, String canvasPagePath) {
        Resource pageResource;
        return resolver.getResource(canvasPagePath) != null && (pageResource = resolver.getResource(canvasPagePath)) != null && ResourceUtil.isA(pageResource.getChild("jcr:content"), MOBILE_CANVAS_PAGE_RESOURCETYPE);
    }

    public boolean isMobileCanvasPage(Page canvasPage) {
        if (canvasPage != null) {
            Resource resource = canvasPage.adaptTo(Resource.class);
            return this.isCanvasPage(resource.getResourceResolver(), canvasPage.getPath());
        }
        return false;
    }

    public boolean isMobileCanvasPage(Resource canvasPageResource) {
        if (canvasPageResource != null) {
            return this.isMobileCanvasPage(canvasPageResource.getResourceResolver(), canvasPageResource.getPath());
        }
        return false;
    }

    public boolean isDesktopCanvasPage(ResourceResolver resolver, String canvasPagePath) {
        Resource pageResource;
        return resolver.getResource(canvasPagePath) != null && (pageResource = resolver.getResource(canvasPagePath)) != null && ResourceUtil.isA(pageResource.getChild("jcr:content"), CANVAS_PAGE_RESOURCETYPE);
    }

    public boolean isDesktopCanvasPage(Page canvasPage) {
        if (canvasPage != null) {
            Resource resource = canvasPage.adaptTo(Resource.class);
            return this.isCanvasPage(resource.getResourceResolver(), canvasPage.getPath());
        }
        return false;
    }

    public boolean isDesktopCanvasPage(Resource canvasPageResource) {
        if (canvasPageResource != null) {
            return this.isDesktopCanvasPage(canvasPageResource.getResourceResolver(), canvasPageResource.getPath());
        }
        return false;
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }

    protected void bindPageManagerFactory(PageManagerFactory pageManagerFactory) {
        this.pageManagerFactory = pageManagerFactory;
    }

    protected void unbindPageManagerFactory(PageManagerFactory pageManagerFactory) {
        if (this.pageManagerFactory == pageManagerFactory) {
            this.pageManagerFactory = null;
        }
    }

    private class CanvasPageAggregateHandler
    extends DefaultAggregateHandler {
        private int numDeleted;

        private CanvasPageAggregateHandler() {
        }

        public void processForReplication(Session session, ReplicationAction action) throws ReplicationException {
            if (action.getType() == ReplicationActionType.DELETE) {
                ArrayList<String> paths = new ArrayList<String>(Arrays.asList(action.getPaths()));
                for (String path : paths) {
                    try {
                        if (session.nodeExists(path)) {
                            session.getNode(path).remove();
                        }
                    }
                    catch (RepositoryException e) {
                        log.warn("Error while deleting node {}: {}", (Object)path, (Object)e.toString());
                    }
                    ++this.numDeleted;
                }
            }
        }
    }
}

