/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser;

import com.day.cq.dam.indd.PageBuilder;
import com.day.cq.dam.indd.PageComponent;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.DesignImporterContext;
import com.day.cq.wcm.designimporter.MissingCanvasException;
import com.day.cq.wcm.designimporter.UnsupportedTagContentException;
import com.day.cq.wcm.designimporter.api.EntryTagHandler;
import com.day.cq.wcm.designimporter.api.HTMLContentProvider;
import com.day.cq.wcm.designimporter.api.PageComponentProvider;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerProvider;
import com.day.cq.wcm.designimporter.parser.HTMLContent;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import com.day.cq.wcm.designimporter.parser.taghandlers.CanvasComponentTagHandler;
import com.day.cq.wcm.designimporter.parser.taghandlers.HeadTagHandler;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLContentHandler
implements ContentHandler {
    protected DesignImporterContext designImporterContext;
    private boolean canvasFound;
    private String canvasResourceType;
    private int counter;
    private HTMLContent headHtmlContent = new HTMLContent();
    private HTMLContent bodyHtmlContent = new HTMLContent();
    private String language;
    private PageBuilder pageBuilder;
    private List<PageComponent> pageComponents;
    private TagHandler tagHandler;
    private TagHandlerProvider tagHandlerProvider;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.tagHandler != null) {
                this.tagHandler.characters(ch, start, length);
            }
        }
        catch (DesignImportException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.canvasFound) {
            throw new SAXException(new MissingCanvasException());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (this.tagHandler instanceof EntryTagHandler) {
                if (--this.counter == 0) {
                    this.tagHandler.endHandling(uri, localName, qName);
                    this.extractComponentsAndContent(this.tagHandler);
                    this.tagHandler = null;
                } else {
                    this.tagHandler.endElement(uri, localName, qName);
                }
            }
        }
        catch (DesignImportException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public HTMLContent getBodyHtmlContent() {
        return this.bodyHtmlContent;
    }

    public List<PageComponent> getGeneratedComponents() {
        return this.pageComponents;
    }

    public HTMLContent getHeadHtmlContent() {
        return this.headHtmlContent;
    }

    public String getLanguage() {
        return this.language;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setCanvasResourceType(String canvasResourceType) {
        this.canvasResourceType = canvasResourceType;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    public void setDesignImporterContext(DesignImporterContext designImporterContext) {
        this.designImporterContext = designImporterContext;
    }

    public void setPageBuilder(PageBuilder pageBuilder) {
        this.pageBuilder = pageBuilder;
    }

    public void setTagHandlerProvider(TagHandlerProvider tagHandlerProvider) {
        this.tagHandlerProvider = tagHandlerProvider;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.canvasFound = false;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("html".equalsIgnoreCase(localName) && atts != null) {
            this.language = atts.getValue("lang");
        }
        try {
            if (this.tagHandler != null) {
                this.tagHandler.startElement(uri, localName, qName, atts);
                ++this.counter;
            } else {
                this.tagHandler = this.tagHandlerProvider.createTagHandler(localName, atts);
                if (this.tagHandler instanceof EntryTagHandler) {
                    this.tagHandler.setDesignImporterContext(this.designImporterContext);
                    this.tagHandler.setTagHandlerProvider(this.tagHandlerProvider);
                    if (this.tagHandler instanceof CanvasComponentTagHandler) {
                        if (this.canvasFound) {
                            throw new UnsupportedTagContentException("041");
                        }
                        this.canvasFound = true;
                        ((CanvasComponentTagHandler)this.tagHandler).setPageBuilder(this.pageBuilder);
                        ((CanvasComponentTagHandler)this.tagHandler).setResourceType(this.canvasResourceType);
                    }
                    this.tagHandler.beginHandling(uri, localName, qName, atts);
                    this.counter = 1;
                } else {
                    this.tagHandler = null;
                }
            }
        }
        catch (DesignImportException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private void extractComponentsAndContent(TagHandler tagHandler) {
        if (tagHandler instanceof PageComponentProvider) {
            this.pageComponents = ((PageComponentProvider)((Object)tagHandler)).getPageComponents();
        }
        if (tagHandler instanceof HTMLContentProvider) {
            for (HTMLContentType contentType : HTMLContentType.values()) {
                Object content;
                if (!((HTMLContentProvider)((Object)tagHandler)).supportsContent(contentType) || (content = ((HTMLContentProvider)((Object)tagHandler)).getContent(contentType)) == null) continue;
                if (tagHandler instanceof HeadTagHandler) {
                    this.headHtmlContent.add(contentType, content);
                    continue;
                }
                this.bodyHtmlContent.add(contentType, content);
            }
        }
    }
}

