/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.designimporter.parser.HTMLContent;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.JcrUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientLibsBuilderImpl {
    private static final String MIMETYPE_CSS = "text/css";
    private static final String MIMETYPE_JS = "application/javascript";
    private static final String MIMETYPE_TEXT_PLAIN = "text/plain";
    private Node designRoot;
    private String folderName;
    private String categoryName;
    private HTMLContent htmlContent;
    private String inlineScriptsFileName;
    private String inlineStylesFileName;

    public void setDesignRoot(Node designRoot) {
        this.designRoot = designRoot;
    }

    public void setFolderName(String folder) {
        this.folderName = folder;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public void setHtmlContent(HTMLContent htmlContent) {
        this.htmlContent = htmlContent;
    }

    public void setInlineScriptsFileName(String fileName) {
        this.inlineScriptsFileName = fileName;
    }

    public void setInlineStylesFileName(String fileName) {
        this.inlineStylesFileName = fileName;
    }

    public void build() throws RepositoryException {
        if (this.htmlContent != null) {
            List referencedScripts = (List)this.htmlContent.get(HTMLContentType.SCRIPT_INCLUDE);
            ArrayList<String> extractedScriptNames = new ArrayList<String>(referencedScripts);
            extractedScriptNames.add(this.inlineScriptsFileName);
            List referencedStyleSheets = (List)this.htmlContent.get(HTMLContentType.STYLESHEET_INCLUDE);
            ArrayList<String> extractedCssNames = new ArrayList<String>(referencedStyleSheets);
            extractedCssNames.add(this.inlineStylesFileName);
            String jsTxtFileContent = this.convertToLineSeparatedNames(extractedScriptNames);
            String cssTxtFileContent = this.convertToLineSeparatedNames(extractedCssNames);
            Node clientLib = JcrUtils.getOrAddNode(this.designRoot, this.folderName, "cq:ClientLibraryFolder");
            JcrUtil.setProperty(clientLib, "categories", new String[]{this.categoryName});
            JcrUtils.putFile(clientLib, "js.txt", MIMETYPE_TEXT_PLAIN, new ByteArrayInputStream(jsTxtFileContent.getBytes()));
            JcrUtils.putFile(clientLib, "css.txt", MIMETYPE_TEXT_PLAIN, new ByteArrayInputStream(cssTxtFileContent.getBytes()));
            String cssContent = (String)this.htmlContent.get(HTMLContentType.STYLES_INLINE);
            String scriptContent = (String)this.htmlContent.get(HTMLContentType.SCRIPT_INLINE);
            JcrUtils.putFile(this.designRoot, this.inlineStylesFileName, MIMETYPE_CSS, new ByteArrayInputStream(cssContent.getBytes()));
            JcrUtils.putFile(this.designRoot, this.inlineScriptsFileName, MIMETYPE_JS, new ByteArrayInputStream(scriptContent.getBytes()));
        }
    }

    private String convertToLineSeparatedNames(List<String> fileNames) {
        String content = "";
        for (String file : fileNames) {
            String referenceableName = "../" + file;
            content = content + referenceableName + "\n";
        }
        return content;
    }
}

