/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.day.cq.dam.indd.PageComponent;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.UnsupportedTagContentException;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import com.day.cq.wcm.designimporter.parser.taghandlers.AbstractTagHandler;
import com.day.cq.wcm.designimporter.parser.taghandlers.ImgTagHandler;
import com.day.cq.wcm.designimporter.util.TagUtils;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.ccil.cowan.tagsoup.AttributesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageComponentTagHandler
extends AbstractTagHandler {
    private Logger logger = LoggerFactory.getLogger(ImageComponentTagHandler.class);
    private String imageFileReference;
    private String alt;
    private String title;
    private String height;
    private String width;
    private String usemap;
    private String suffix;
    private String resourceType;

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        super.beginHandling(uri, localName, qName, atts);
        if ("img".equalsIgnoreCase(localName)) {
            AttributesImpl modAttibutes = new AttributesImpl(atts);
            int index = atts.getIndex("data-cq-component");
            if (index > -1) {
                modAttibutes.removeAttribute(index);
            }
            this.startElement(uri, localName, qName, (Attributes)modAttibutes);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        if (this.imageFileReference != null) {
            throw new UnsupportedTagContentException("044");
        }
        super.startElement(uri, localName, qName, atts);
        if (!(this.delegate instanceof ImgTagHandler)) {
            throw new UnsupportedTagContentException("044");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws DesignImportException {
        super.characters(ch, start, length);
        if (this.delegate == null && new String(ch, start, length).trim().length() > 0) {
            throw new UnsupportedTagContentException("045");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws DesignImportException {
        if (this.delegate instanceof ImgTagHandler) {
            if (((ImgTagHandler)this.delegate).isRawSrcAbsolute()) {
                throw new UnsupportedTagContentException("046");
            }
            this.imageFileReference = this.getDesignPath() + "/" + ((ImgTagHandler)this.delegate).getRawSrc();
            this.alt = ((ImgTagHandler)this.delegate).getAlt();
            this.title = ((ImgTagHandler)this.delegate).getTitle();
            this.height = ((ImgTagHandler)this.delegate).getHeight();
            this.width = ((ImgTagHandler)this.delegate).getWidth();
            this.usemap = ((ImgTagHandler)this.delegate).getUsemap();
        }
        super.endElement(uri, localName, qName);
    }

    private String getDesignPath() {
        try {
            return this.designImporterContext.designNode.getPath();
        }
        catch (RepositoryException e) {
            this.logger.error("A repository exception occured while trying to obtain the design path from the page context", (Throwable)e);
            return "";
        }
    }

    @Override
    public void endHandling(String uri, String localName, String qName) throws DesignImportException {
        super.endHandling(uri, localName, qName);
        if ("img".equalsIgnoreCase(localName)) {
            this.endElement(uri, localName, qName);
        }
        ValueMapDecorator properties = new ValueMapDecorator(this.getPropertyMap());
        this.suffix = this.designImporterContext.componentSuffixGenerator.getSuffix("image");
        PageComponent imageComponent = this.pageBuilder.createComponent(this.resourceType, properties, this.getNameHint());
        this.getPageComponents().add(imageComponent);
    }

    @Override
    public boolean supportsContent(HTMLContentType htmlContentType) {
        return htmlContentType == HTMLContentType.MARKUP;
    }

    private String getNameHint() {
        return "image" + this.suffix;
    }

    @Override
    public Object getContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.MARKUP) {
            String cqIncludeJspTag = "<sling:include path=\"" + this.getNameHint() + "\"" + "/>";
            return this.componentDivStartTag + cqIncludeJspTag + TagUtils.getMatchingEndTag(this.componentDivStartTag);
        }
        return null;
    }

    private Map<String, Object> getPropertyMap() {
        HashMap<String, Object> base = new HashMap<String, Object>();
        base.put("fileReference", this.imageFileReference);
        if (this.alt != null) {
            base.put("alt", this.alt);
        }
        if (this.title != null) {
            base.put("jcr:title", this.title);
        }
        if (this.width != null) {
            base.put("width", this.width);
        }
        if (this.height != null) {
            base.put("height", this.height);
        }
        if (this.usemap != null) {
            if (this.usemap.startsWith("#")) {
                base.put("imageMap", this.usemap.substring(1));
            } else {
                base.put("imageMap", this.usemap);
            }
        }
        return base;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }
}

