/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.DesignImporterContext;
import com.day.cq.wcm.designimporter.UnsupportedTagContentException;
import com.day.cq.wcm.designimporter.api.EntryTagHandler;
import com.day.cq.wcm.designimporter.api.HTMLContentProvider;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerProvider;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import javax.jcr.RepositoryException;
import org.xml.sax.Attributes;

public class ScriptTagHandler
implements TagHandler,
EntryTagHandler,
HTMLContentProvider {
    private boolean isAbsolutePath = false;
    private DesignImporterContext designImporterContext;
    private String scriptPath;

    public void beginHandling(String uri, String localName, String qName, Attributes atts) {
        this.scriptPath = atts.getValue("src");
        if (this.isValidURL(this.scriptPath)) {
            this.isAbsolutePath = true;
        } else {
            if (this.scriptPath != null) {
                this.scriptPath = this.scriptPath.replaceAll("([^?]*)?.*", "$1");
            }
            try {
                if (!this.designImporterContext.designNode.hasNode(this.scriptPath)) {
                    this.designImporterContext.importWarnings.add("Could not locate the referenced script '" + this.scriptPath + "' in the design package");
                }
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws DesignImportException {
        if (new String(ch, start, length).trim().length() > 0) {
            throw new UnsupportedTagContentException("048");
        }
    }

    public void endElement(String uri, String localName, String qName) throws DesignImportException {
        throw new UnsupportedTagContentException();
    }

    public void endHandling(String uri, String localName, String qName) {
    }

    public Object getContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.SCRIPT_INCLUDE) {
            return Arrays.asList(this.scriptPath);
        }
        if (htmlContentType == HTMLContentType.MARKUP) {
            return "<script type='text/javascript' src='" + this.scriptPath + "'></script>";
        }
        return null;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setDesignImporterContext(DesignImporterContext designImporterContext) {
        this.designImporterContext = designImporterContext;
    }

    public void setTagHandlerProvider(TagHandlerProvider tagHandlerProvider) {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        throw new UnsupportedTagContentException();
    }

    public boolean supportsContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.SCRIPT_INCLUDE) {
            return !this.isAbsolutePath;
        }
        if (htmlContentType == HTMLContentType.MARKUP) {
            return this.isAbsolutePath;
        }
        return false;
    }

    private boolean isValidURL(String scriptPath) {
        try {
            URL uri = new URL(scriptPath);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }
}

