/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.DesignImporterContext;
import com.day.cq.wcm.designimporter.UnsupportedTagContentException;
import com.day.cq.wcm.designimporter.api.EntryTagHandler;
import com.day.cq.wcm.designimporter.api.HTMLContentProvider;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerProvider;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import org.xml.sax.Attributes;

public class StyleTagHandler
implements TagHandler,
EntryTagHandler,
HTMLContentProvider {
    private StringBuffer cssBuffer = new StringBuffer();
    private boolean keepInline = false;

    public void beginHandling(String uri, String localName, String qName, Attributes atts) {
        String cqInline = atts.getValue("data-cq-inline");
        if (cqInline != null && cqInline.trim().equalsIgnoreCase("true")) {
            this.keepInline = true;
        }
    }

    public void characters(char[] ch, int start, int length) throws DesignImportException {
        String chars = new String(ch).substring(start, start + length);
        if (chars.length() > 0) {
            this.cssBuffer.append(chars);
        }
    }

    public void endElement(String uri, String localName, String qName) throws DesignImportException {
        throw new UnsupportedTagContentException();
    }

    public void endHandling(String uri, String localName, String qName) {
    }

    public Object getContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.STYLES_INLINE) {
            return this.cssBuffer.toString();
        }
        if (htmlContentType == HTMLContentType.MARKUP) {
            return "<style>" + this.cssBuffer.toString() + "</style>";
        }
        return null;
    }

    public void setDesignImporterContext(DesignImporterContext designImporterContext) {
    }

    public void setTagHandlerProvider(TagHandlerProvider tagHandlerProvider) {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        throw new UnsupportedTagContentException();
    }

    public boolean supportsContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.STYLES_INLINE) {
            return !this.keepInline;
        }
        if (htmlContentType == HTMLContentType.MARKUP) {
            return this.keepInline;
        }
        return false;
    }
}

