/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.util;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.designimporter.impl.common.PathSchemeHelper;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImporterUtil {
    public static Resource findImporter(Resource resource) {
        List<Resource> found = ImporterUtil.findImporters(resource);
        if (found.size() > 0) {
            return found.get(0);
        }
        return null;
    }

    public static List<Resource> findImporters(Resource resource) {
        return ImporterUtil.findImporters(resource, false);
    }

    public static List<Resource> findImporters(Resource resource, boolean recursive) {
        LinkedList<Resource> found = new LinkedList<Resource>();
        if (resource != null) {
            Page page = resource.adaptTo(Page.class);
            if (recursive) {
                ImporterUtil.findImporterComponent(resource, found);
            } else {
                ImporterUtil.findImporterComponent(page.getContentResource(), found);
            }
        }
        return found;
    }

    public static boolean checkCanvasPrimary(Resource resource) throws IllegalArgumentException {
        return !ImporterUtil.checkCanvasSecondary(resource);
    }

    public static boolean checkCanvasSecondary(Resource resource) throws IllegalArgumentException {
        ValueMap valueMap;
        if (!ImporterUtil.isCanvas(resource)) {
            throw new IllegalArgumentException("The passed resource is not a valid canvas resource");
        }
        Resource canvas = ImporterUtil.getCanvas(resource);
        Resource importer = canvas.getParent();
        if (canvas != null && (valueMap = importer.adaptTo(ValueMap.class)).containsKey("cq:secondaryCanvas")) {
            return (Boolean)((Object)valueMap.get("cq:secondaryCanvas", Boolean.class));
        }
        return false;
    }

    public static Resource getCanvasDesign(Resource resource) {
        Resource canvas = ImporterUtil.getCanvas(resource);
        PageManager pm = resource.getResourceResolver().adaptTo(PageManager.class);
        if (ImporterUtil.checkCanvasSecondary(canvas)) {
            Page primaryPage = pm.getContainingPage(canvas).getParent();
            Resource importer = ImporterUtil.findImporter(primaryPage.adaptTo(Resource.class));
            canvas = ImporterUtil.getCanvas(importer);
        }
        String canvasDesignPath = PathSchemeHelper.getCanvasDesignPath((Resource)canvas);
        return resource.getResourceResolver().resolve(canvasDesignPath);
    }

    public static Resource getCanvas(Resource resource) {
        if (ResourceUtil.isA(resource, "wcm/designimporter/components/importer")) {
            return resource.getChild("canvas");
        }
        if (ResourceUtil.isA(resource.getParent(), "wcm/designimporter/components/importer")) {
            return resource;
        }
        return null;
    }

    private static void findImporterComponent(Resource root, List<Resource> components) {
        if (ImporterUtil.isImporter(root)) {
            components.add(root);
        } else {
            Iterator<Resource> childIterator = root.listChildren();
            while (childIterator.hasNext()) {
                Resource child = childIterator.next();
                ImporterUtil.findImporterComponent(child, components);
            }
        }
    }

    public static boolean isCanvas(Resource resource) {
        if (resource == null) {
            return false;
        }
        if (ImporterUtil.isImporter(resource.getParent())) {
            return true;
        }
        return ResourceUtil.isA(resource.getParent(), "wcm/designimporter/components/canvaspage");
    }

    public static boolean isImporter(Resource resource) {
        return ResourceUtil.isA(resource, "wcm/designimporter/components/importer");
    }

    public static boolean isImporterPage(Page page) {
        if (page == null) {
            return false;
        }
        return ResourceUtil.isA(page.getContentResource(), "wcm/designimporter/components/importerpage");
    }

    public static boolean isImporterPage(Resource resource) {
        PageManager pageManager = resource.getResourceResolver().adaptTo(PageManager.class);
        Page containingPage = pageManager.getContainingPage(resource);
        return ImporterUtil.isImporterPage(containingPage);
    }

    public static void deleteCanvasArtifact(Resource resource) throws RepositoryException {
        ImporterUtil.deleteCanvasArtifact(resource, true);
    }

    public static void deleteCanvasArtifact(Resource resource, boolean cleanupDanglingAscendants) throws RepositoryException {
        if (resource != null && !ResourceUtil.isNonExistingResource(resource)) {
            Node node = resource.adaptTo(Node.class);
            node.remove();
            node.getSession().save();
            if (cleanupDanglingAscendants) {
                ImporterUtil.cleanupDanglingAscendants(resource);
            }
        }
    }

    public static void cleanupDanglingAscendants(Resource resource) throws RepositoryException {
        if (resource.getPath().contains("/canvas/")) {
            Resource last;
            boolean parentHasMoreChildren;
            boolean isParentCanvas;
            if (resource.getParent().listChildren().hasNext()) {
                return;
            }
            Resource curr = resource;
            do {
                last = curr;
                curr = curr.getParent();
                isParentCanvas = "canvas".equals(curr.getName());
                Iterator<Resource> iter = curr.listChildren();
                if (iter.hasNext()) {
                    iter.next();
                }
                parentHasMoreChildren = iter.hasNext();
            } while (!isParentCanvas && !parentHasMoreChildren);
            last.adaptTo(Node.class).remove();
        }
    }

    public static Resource getDanglingAscendantRoot(Resource resource) throws RepositoryException {
        if (resource.getPath().contains("/canvas/") && !resource.getParent().listChildren().hasNext()) {
            Resource last;
            boolean parentHasMoreChildren;
            boolean isParentCanvas;
            Resource curr = resource;
            do {
                last = curr;
                curr = curr.getParent();
                isParentCanvas = "canvas".equals(curr.getName());
                Iterator<Resource> iter = curr.listChildren();
                if (iter.hasNext()) {
                    iter.next();
                }
                parentHasMoreChildren = iter.hasNext();
            } while (!isParentCanvas && !parentHasMoreChildren);
            return last;
        }
        return resource;
    }
}

