/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.cq.wcm.foundation.Paragraph;
import com.day.cq.wcm.foundation.ParagraphSystem;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.commons.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.paths", value={"/bin/wcm/foundation/paragraphlist"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class ParagraphList
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 2156140435583248698L;
    public static final String QUERY = "query";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            Resource content;
            StringWriter writer = new StringWriter();
            TidyJSONWriter json = new TidyJSONWriter(writer);
            json.object();
            json.key("hits");
            json.array();
            Page page = null;
            try {
                String path = request.getRequestParameter(QUERY).getString().replace("path:", "");
                page = request.getResourceResolver().getResource(path).adaptTo(Page.class);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (page != null && (content = page.getContentResource()) != null) {
                try {
                    ParagraphWriter pw = new ParagraphWriter(request, response, json);
                    pw.writeParagraphSystems(content);
                }
                catch (JSONException e) {
                    throw new ServletException("Failed to produce JSON output", (Throwable)e);
                }
            }
            json.endArray();
            json.key("results").value(0L);
            json.endObject();
            if ("json".equals(request.getRequestPathInfo().getExtension())) {
                response.setContentType("application/json");
                response.setCharacterEncoding("utf-8");
            }
            response.getWriter().write(writer.toString());
        }
        catch (JSONException e) {
            throw new ServletException("Failed to produce JSON output", (Throwable)e);
        }
    }

    void writeEmptyJSON(SlingHttpServletResponse response) throws ServletException, IOException {
    }

    private static class ParagraphWriter {
        private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
        private final TidyJSONWriter json;
        private final SlingHttpServletRequest request;
        private final SlingHttpServletResponse response;

        public ParagraphWriter(SlingHttpServletRequest request, SlingHttpServletResponse response, TidyJSONWriter json) {
            this.request = request;
            this.response = response;
            this.json = json;
        }

        public void writeParagraphSystems(Resource content) throws JSONException, IOException {
            WCMMode.DISABLED.toRequest((ServletRequest)this.request);
            Iterator<Resource> iterator = content.getResourceResolver().listChildren(content);
            while (iterator.hasNext()) {
                Resource resource = iterator.next();
                com.day.cq.wcm.api.components.Component component = WCMUtils.getComponent(resource);
                if (component == null || !component.isContainer()) continue;
                this.writeParagraphs(resource);
            }
        }

        public void writeParagraphs(Resource container) throws JSONException {
            ParagraphSystem system = new ParagraphSystem(container);
            for (Paragraph paragraph : system.paragraphs()) {
                if (paragraph.getType() != Paragraph.Type.NORMAL) continue;
                this.json.object();
                this.json.key("path").value(paragraph.getPath());
                this.json.key("excerpt").value(this.render(paragraph.getPath()));
                this.json.endObject();
            }
        }

        public String render(String path) {
            try {
                final StringWriter buffer = new StringWriter();
                final ServletOutputStream stream = new ServletOutputStream(){

                    public void write(int b) throws IOException {
                        buffer.append((char)b);
                    }
                };
                SlingHttpServletResponseWrapper wrapper = new SlingHttpServletResponseWrapper(this.response){

                    public ServletOutputStream getOutputStream() {
                        return stream;
                    }

                    public PrintWriter getWriter() throws IOException {
                        return new PrintWriter(buffer);
                    }

                    public SlingHttpServletResponse getSlingResponse() {
                        return super.getSlingResponse();
                    }
                };
                RequestDispatcher dispatcher = this.request.getRequestDispatcher(path + ".html");
                dispatcher.include((ServletRequest)this.request, (ServletResponse)wrapper);
                return ((Object)buffer).toString();
            }
            catch (Exception e) {
                this.logger.error("Exception occured: " + e.getMessage(), (Throwable)e);
                return e.getMessage();
            }
        }
    }
}

