/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.commons.TidyJSONWriter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.cq.wcm.foundation.Paragraph;
import com.day.cq.wcm.foundation.ParagraphSystem;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.commons.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.selectors", value={"paragraphs"}), @Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class ParagraphServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 2156140435583248698L;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Page page = request.getResource().adaptTo(Page.class);
        if (page == null) {
            response.sendError(404, "Page not found: " + request.getResource().getPath());
            return;
        }
        Resource content = page.getContentResource();
        if (content == null) {
            response.sendError(404, "Content not found: " + page.getPath());
            return;
        }
        try {
            new ParagraphWriter(request, response).writeParagraphSystems(content);
        }
        catch (JSONException e) {
            throw new ServletException("Failed to produce JSON output", (Throwable)e);
        }
    }

    private static class ParagraphWriter {
        private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
        private final Writer writer = new StringWriter();
        private final TidyJSONWriter json = new TidyJSONWriter(this.writer);
        private final SlingHttpServletRequest request;
        private final SlingHttpServletResponse response;
        private long count = 0L;

        public ParagraphWriter(SlingHttpServletRequest request, SlingHttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public void writeParagraphSystems(Resource content) throws JSONException, IOException {
            WCMMode.DISABLED.toRequest((ServletRequest)this.request);
            this.json.object();
            this.json.key("paragraphs");
            this.json.array();
            Iterator<Resource> iterator = content.getResourceResolver().listChildren(content);
            while (iterator.hasNext()) {
                Resource resource = iterator.next();
                com.day.cq.wcm.api.components.Component component = WCMUtils.getComponent(resource);
                if (component == null || !component.isContainer()) continue;
                this.writeParagraphs(resource);
            }
            this.json.endArray();
            this.json.key("count").value(this.count);
            this.json.endObject();
            this.response.setContentType("application/json; charset=UTF-8");
            this.response.getWriter().write(this.writer.toString());
        }

        public void writeParagraphs(Resource container) throws JSONException {
            ParagraphSystem system = new ParagraphSystem(container);
            for (Paragraph paragraph : system.paragraphs()) {
                if (paragraph.getType() != Paragraph.Type.NORMAL) continue;
                this.json.object();
                this.json.key("path").value(paragraph.getPath());
                this.json.key("html").value(this.render(paragraph.getPath()));
                this.json.endObject();
                ++this.count;
            }
        }

        public String render(String path) {
            try {
                final StringWriter buffer = new StringWriter();
                final ServletOutputStream stream = new ServletOutputStream(){

                    public void write(int b) throws IOException {
                        buffer.append((char)b);
                    }
                };
                SlingHttpServletResponseWrapper wrapper = new SlingHttpServletResponseWrapper(this.response){

                    public ServletOutputStream getOutputStream() {
                        return stream;
                    }

                    public PrintWriter getWriter() throws IOException {
                        return new PrintWriter(buffer);
                    }

                    public SlingHttpServletResponse getSlingResponse() {
                        return super.getSlingResponse();
                    }
                };
                RequestDispatcher dispatcher = this.request.getRequestDispatcher(path + ".html");
                dispatcher.include((ServletRequest)this.request, (ServletResponse)wrapper);
                return ((Object)buffer).toString();
            }
            catch (Exception e) {
                this.logger.error("Exception occured: " + e.getMessage(), (Throwable)e);
                return e.getMessage();
            }
        }
    }
}

