/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.wcm.foundation.Table;

public class TableCSVBuilder {
    private static final char S_CELL = 'c';
    private static final char S_QUOTE = 'q';
    private static final char S_CR = 'r';
    private static final char S_LF = 'n';
    private final char colDelim;

    public TableCSVBuilder() {
        this('\t');
    }

    public TableCSVBuilder(char colDelim) {
        this.colDelim = colDelim;
    }

    public Table parse(String string) {
        int state = 99;
        StringBuffer cellBuf = new StringBuffer();
        int rowNr = 0;
        int colNr = 0;
        Table table = new Table();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (state) {
                case 99: {
                    if (c == '\"') {
                        state = 113;
                        continue block6;
                    }
                    if (c == '\r' || c == '\n') {
                        if (cellBuf.length() > 0) {
                            table.getCell(rowNr, colNr, true).setText(cellBuf);
                            cellBuf.setLength(0);
                        }
                        ++rowNr;
                        colNr = 0;
                        state = c == '\r' ? 114 : 110;
                        continue block6;
                    }
                    if (c == this.colDelim) {
                        table.getCell(rowNr, colNr, true).setText(cellBuf);
                        ++colNr;
                        cellBuf.setLength(0);
                        continue block6;
                    }
                    cellBuf.append(c);
                    continue block6;
                }
                case 113: {
                    if (c == '\"') {
                        state = 99;
                        continue block6;
                    }
                    cellBuf.append(c);
                    continue block6;
                }
                case 114: {
                    state = 99;
                    if (c == '\n') continue block6;
                    --i;
                    continue block6;
                }
                case 110: {
                    state = 99;
                    if (c == '\r') continue block6;
                    --i;
                }
            }
        }
        if (cellBuf.length() > 0) {
            table.getCell(rowNr, colNr, true).setText(cellBuf);
        }
        return table;
    }
}

