/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms;

import com.day.cq.wcm.foundation.forms.ValidationInfo;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.sling.api.SlingHttpServletRequest;

public class LayoutHelper {
    private LayoutHelper() {
    }

    public static void printTitle(String fieldId, String title, boolean required, Writer out) throws IOException {
        LayoutHelper.printTitle(fieldId, title, required, false, out);
    }

    public static void printTitle(String fieldId, String title, boolean required, boolean hideLabel, Writer out) throws IOException {
        out.write("<div class=\"form_leftcol\"");
        if (hideLabel) {
            out.write(" style=\"display: none;\"");
        }
        title = title != null && title.length() > 0 ? StringEscapeUtils.escapeHtml4((String)title) : "&nbsp;";
        out.write(">");
        out.write("<div class=\"form_leftcollabel\">");
        if (fieldId != null) {
            fieldId = StringEscapeUtils.escapeHtml4((String)fieldId);
            out.write("<label for=\"" + fieldId + "\">" + title + "</label>");
        } else {
            out.write("<span>" + title + "</span>");
        }
        out.write("</div>");
        out.write("<div class=\"form_leftcolmark\">");
        if (!hideLabel) {
            if (required) {
                out.write(" *");
            } else {
                out.write("&nbsp;");
            }
        }
        out.write("</div>");
        out.write("</div>\n");
    }

    public static void printDescription(String descr, Writer out) throws IOException {
        LayoutHelper.printDescription(null, descr, out);
    }

    public static void printDescription(String fieldId, String descr, Writer out) throws IOException {
        out.write("<div class=\"form_row_description\">");
        if (descr != null && descr.length() > 0) {
            descr = StringEscapeUtils.escapeHtml4((String)descr);
            if (fieldId != null) {
                fieldId = StringEscapeUtils.escapeHtml4((String)fieldId);
                out.write("<label for=\"" + fieldId + "\">" + descr + "</label>");
            } else {
                out.write("<span>" + descr + "</span>");
            }
        }
        out.write("</div>\n");
    }

    public static void printErrors(SlingHttpServletRequest request, String fieldName, Writer out) throws IOException {
        LayoutHelper.printErrors(request, fieldName, false, out);
    }

    public static boolean printErrors(SlingHttpServletRequest request, String fieldName, Writer out, int valueIndex) throws IOException {
        return LayoutHelper.printErrors(request, fieldName, false, out, valueIndex);
    }

    public static void printErrors(SlingHttpServletRequest request, String fieldName, boolean hideLabel, Writer out) throws IOException {
        String[] msgs;
        ValidationInfo info = ValidationInfo.getValidationInfo(request);
        if (info != null && (msgs = info.getErrorMessages(fieldName)) != null) {
            for (String msg : msgs) {
                out.write("<div class=\"form_row\">");
                LayoutHelper.printTitle(null, null, false, hideLabel, out);
                out.write("<div class=\"form_rightcol form_error\">");
                String[] msgParas = msg.split("\n");
                for (int i = 0; i < msgParas.length; ++i) {
                    out.write(StringEscapeUtils.escapeHtml4((String)msgParas[i]));
                    if (i + 1 >= msgParas.length) continue;
                    out.write("<br>");
                }
                out.write("</div>");
                out.write("</div>");
            }
        }
    }

    public static boolean printErrors(SlingHttpServletRequest request, String fieldName, boolean hideLabel, Writer out, int valueIndex) throws IOException {
        String[] msgs;
        ValidationInfo info = ValidationInfo.getValidationInfo(request);
        if (info != null && (msgs = info.getErrorMessages(fieldName, valueIndex)) != null) {
            for (String msg : msgs) {
                out.write("<div class=\"form_row\">");
                LayoutHelper.printTitle(null, null, false, hideLabel, out);
                out.write("<div class=\"form_rightcol form_error\">");
                String[] msgParas = msg.split("\n");
                for (int i = 0; i < msgParas.length; ++i) {
                    out.write(StringEscapeUtils.escapeHtml4((String)msgParas[i]));
                    if (i + 1 >= msgParas.length) continue;
                    out.write("<br>");
                }
                out.write("</div>");
                out.write("</div>");
            }
            return true;
        }
        return false;
    }
}

