/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.msm.commons;

import com.day.cq.wcm.msm.api.RolloutManager;
import com.day.cq.wcm.msm.commons.ItemFilterImpl;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.sling.commons.osgi.PropertiesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemFilterUtil {
    public static final String[] EMPTY_PROPERTIES = new String[0];
    public static final String PARAMETER_EXCLUDED_PROPERTIES = "cq.wcm.msm.action.excludedprops";
    public static final String[] EXCLUDED_PROPERTIES_DEFAULT = new String[]{"jcr:.*", "sling:.*", "cq:.*"};
    public static final String PARAMETER_EXCLUDED_PARAGRAPH_ITEMS = "cq.wcm.msm.action.excludedparagraphitems";
    public static final String[] EXCLUDED_PARAGRAPH_ITEMS_DEFAULT = new String[]{"cq:propertyInheritanceCancelled"};
    public static final String PARAMETER_EXCLUDED_NODE_TYPES = "cq.wcm.msm.action.excludednodetypes";
    public static final String[] EXCLUDED_NODE_TYPES_DEFAULT = new String[]{"cq:LiveSyncAction", "cq:LiveSyncConfig", "cq:BlueprintSyncConfig"};

    public static ItemFilterImpl createPageFilter(Dictionary properties, RolloutManager rolloutManager) {
        String[] pageProperties = PropertiesUtil.toStringArray(properties.get(PARAMETER_EXCLUDED_PROPERTIES), EMPTY_PROPERTIES);
        String[] nodeTypes = PropertiesUtil.toStringArray(properties.get(PARAMETER_EXCLUDED_NODE_TYPES), EMPTY_PROPERTIES);
        return ItemFilterUtil.createFilter(nodeTypes, null, pageProperties, rolloutManager);
    }

    public static ItemFilterImpl createComponentFilter(Dictionary properties, RolloutManager rolloutManager) {
        String[] paragraphItems = PropertiesUtil.toStringArray(properties.get(PARAMETER_EXCLUDED_PARAGRAPH_ITEMS), EMPTY_PROPERTIES);
        String[] nodeTypes = PropertiesUtil.toStringArray(properties.get(PARAMETER_EXCLUDED_NODE_TYPES), EMPTY_PROPERTIES);
        return ItemFilterUtil.createFilter(nodeTypes, paragraphItems, paragraphItems, rolloutManager);
    }

    public static ItemFilterImpl createFilter(String[] nodeTypes, String[] nodeNames, String[] propertyNames, RolloutManager rolloutManager) {
        return new ItemFilterImpl(ItemFilterUtil.buildPatterns(nodeTypes), ItemFilterUtil.buildPatterns(nodeNames), ItemFilterUtil.buildPatterns(propertyNames), rolloutManager);
    }

    private static Set<Pattern> buildPatterns(String ... patterns) {
        if (patterns != null && patterns.length > 0) {
            HashSet<Pattern> pats = new HashSet<Pattern>(patterns.length);
            for (String pattern : patterns) {
                pats.add(Pattern.compile(pattern));
            }
            return Collections.unmodifiableSet(pats);
        }
        return Collections.emptySet();
    }
}

