/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.notification;

import com.day.cq.security.Authorizable;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public abstract class NotificationUtil {
    public static final String PROPERTY_CHANNEL_TYPE = "type";
    public static final String PROPERTY_CHANNEL_NAME = "channel";
    public static final String PROPERTY_SUBSCRIPTION_TYPE = "type";

    public static String getChannelType(Map channelConfig) {
        return null != channelConfig ? (String)channelConfig.get("type") : null;
    }

    public static String getChannelName(Map subscriptionConfig) {
        return null != subscriptionConfig ? (String)subscriptionConfig.get(PROPERTY_CHANNEL_NAME) : null;
    }

    public static String getSubscriptionType(Map subscriptionConfig) {
        return null != subscriptionConfig ? (String)subscriptionConfig.get("type") : null;
    }

    public static Node getNotificationNode(Authorizable authorizable) throws RepositoryException {
        Node n = authorizable.adaptTo(Node.class);
        if (n != null) {
            return NotificationUtil.getNotificationNode(authorizable, n.getSession());
        }
        return null;
    }

    public static Node getNotificationNode(Authorizable authorizable, Session s) throws RepositoryException {
        Node productNode;
        Node authorizableHome = (Node)s.getItem(authorizable.getHomePath());
        boolean save = false;
        if (!authorizableHome.hasNode("wcm")) {
            authorizableHome.addNode("wcm", "sling:Folder");
            save = true;
        }
        if (!(productNode = authorizableHome.getNode("wcm")).hasNode("notification")) {
            productNode.addNode("notification", "sling:Folder");
            save = true;
        }
        if (save) {
            s.save();
        }
        return productNode.getNode("notification");
    }
}

