/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.notification.email;

import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.security.Authorizable;
import com.day.cq.wcm.notification.NotificationContext;
import com.day.cq.wcm.notification.email.EmailBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEmailBuilder
implements EmailBuilder {
    protected static final String TEMPLATE_ROOT_PATH = "/etc/notification/email/default";
    protected static final String DEFAULT_CONTENT_TYPE = "text/plain; charset=utf-8";
    protected static final String DEFAULT_CHARSET = "UTF-8";
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());

    protected abstract ResourceResolverFactory getResolverFactory();

    protected abstract Map<String, String> getHeaders(NotificationContext var1, Event var2);

    protected abstract String getSubject(NotificationContext var1, Event var2, Properties var3);

    protected abstract String getMessage(NotificationContext var1, Event var2, Properties var3);

    protected String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    protected String getCharset() {
        return DEFAULT_CHARSET;
    }

    protected String getTemplateRootPath() {
        return TEMPLATE_ROOT_PATH;
    }

    @Override
    public boolean shouldBuild(NotificationContext context, Event event) {
        return true;
    }

    @Override
    public Email build(NotificationContext context, Event event, String addressFrom) {
        SimpleEmail email = null;
        Authorizable authorizable = context.getUser();
        String addressTo = authorizable.getProfile().getPrimaryMail();
        if (StringUtils.isNotBlank((String)addressTo)) {
            try {
                Properties properties = this.loadEmailProperties(context, event);
                email = new SimpleEmail();
                HashMap<String, String> headerMap = new HashMap<String, String>();
                headerMap.put("Content-Type", this.getContentType());
                headerMap.putAll(this.getHeaders(context, event));
                email.setHeaders(headerMap);
                email.setCharset(this.getCharset());
                email.addTo(addressTo);
                email.setFrom(StringUtils.defaultIfEmpty((String)addressFrom, (String)"cq5@acme.com"));
                email.setSubject(this.getSubject(context, event, properties));
                email.setMsg(this.getMessage(context, event, properties));
                return email;
            }
            catch (RepositoryException e) {
                this.log.error("failed building notification email template for user [{}] with destination [" + addressTo + "]: {}", (Object)authorizable.getID(), (Object)e);
            }
            catch (IOException e) {
                this.log.error("failed loading email text for user [{}] with destination [" + addressTo + "]: {}", (Object)authorizable.getID(), (Object)e);
            }
            catch (EmailException e) {
                this.log.error("failed building email for user [{}] with destination [" + addressTo + "]: {}", (Object)authorizable.getID(), (Object)e);
            }
        } else {
            this.log.error("failed building notification email, user [{}] has no email address set.", (Object)authorizable.getID());
        }
        return email;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadEmailProperties(NotificationContext context, Event event) throws RepositoryException, IOException {
        Properties properties = new Properties();
        Session userSession = null;
        ResourceResolver resolver = null;
        try {
            SimpleCredentials credentials = new SimpleCredentials(context.getUser().getID(), new char[0]);
            userSession = context.getAdministrativeSession().impersonate((Credentials)credentials);
            resolver = this.getResolverFactory().getResourceResolver(Collections.singletonMap("jcr.user.session", userSession));
            UserPropertiesManager userPropertiesManager = resolver.adaptTo(UserPropertiesManager.class);
            UserProperties preferences = userPropertiesManager.getUserProperties(context.getUser().getID(), "preferences");
            String language = null != preferences ? StringUtils.defaultIfEmpty((String)preferences.getProperty("language"), (String)"en") : "en";
            String templateRoot = this.getTemplateRootPath();
            String path = templateRoot + "/" + event.getTopic().replace('/', '.') + "/" + language + ".txt";
            Node node = context.getAdministrativeSession().getNode(path);
            InputStream is = node.getNode("jcr:content").getProperty("jcr:data").getBinary().getStream();
            properties.load(is);
        }
        catch (LoginException e) {
            this.log.error("error obtaining resource resolver: ", (Throwable)e);
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
            if (userSession != null) {
                userSession.logout();
            }
        }
        return properties;
    }
}

