/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.siteimporter;

import com.day.cq.wcm.siteimporter.ImporterContext;
import com.day.cq.wcm.siteimporter.internal.resource.BinaryImporterResource;
import com.day.cq.wcm.siteimporter.internal.resource.CssImporterResource;
import com.day.cq.wcm.siteimporter.internal.resource.HtmlImporterResource;
import com.day.cq.wcm.siteimporter.internal.resource.ImporterResource;
import com.day.cq.wcm.siteimporter.internal.resource.JsImporterResource;
import java.net.URL;
import java.util.Hashtable;

public class ResourcesBoard {
    public static final int HTML = 0;
    public static final int CSS = 1;
    public static final int JS = 2;
    public static final int BINARY = 3;
    private Hashtable<String, ImporterResource> resources = new Hashtable();

    public ImporterResource getResource(URL location, int type, ImporterContext ctx) {
        if (this.resources.containsKey(location.toString())) {
            return this.resources.get(location.toString());
        }
        ImporterResource resource = this.createResource(location, type, ctx);
        this.resources.put(location.toString(), resource);
        return resource;
    }

    public ImporterResource getResource(URL location, ImporterContext ctx) {
        return this.getResource(location, this.extractType(location), ctx);
    }

    private int extractType(URL location) {
        String resourcePath = location.getPath();
        int lastSlash = resourcePath.lastIndexOf("/");
        int lastDot = resourcePath.lastIndexOf(".");
        String extension = "";
        if (lastSlash < lastDot) {
            extension = resourcePath.substring(lastDot + 1).toLowerCase();
        }
        if ("js".equals(extension)) {
            return 2;
        }
        if ("css".equals(extension)) {
            return 1;
        }
        if ("html".equals(extension) || "htm".equals(extension)) {
            return 0;
        }
        return 3;
    }

    private ImporterResource createResource(URL location, int type, ImporterContext ctx) {
        if (this.resources.contains(location)) {
            return this.resources.get(location);
        }
        if (type == 0) {
            return new HtmlImporterResource(location, ctx);
        }
        if (type == 1) {
            return new CssImporterResource(location, ctx);
        }
        if (type == 2) {
            return new JsImporterResource(location, ctx);
        }
        if (type == 3) {
            return new BinaryImporterResource(location, ctx);
        }
        return null;
    }
}

