/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.tags;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.scripting.jsp.util.JspSlingHttpServletResponseWrapper;
import org.apache.sling.scripting.jsp.util.TagUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeTag
extends TagSupport {
    static final long serialVersionUID = -5953960896840203934L;
    private static final Logger log = LoggerFactory.getLogger(IncludeTag.class);
    private String resourceType;
    private String path;
    private String script;
    private boolean flush;
    private boolean ignoreComponentHierarchy;

    public int doEndTag() throws JspException {
        if (this.script != null) {
            return this.includeScript();
        }
        if (this.path != null && this.resourceType != null) {
            return this.includeResource();
        }
        throw new JspException("Either path/resourceType or script must be defined.");
    }

    private int includeScript() throws JspException {
        Servlet servlet;
        SlingBindings bindings = (SlingBindings)this.pageContext.getRequest().getAttribute(SlingBindings.class.getName());
        SlingScriptHelper scriptHelper = bindings.getSling();
        ServletResolver servletResolver = scriptHelper.getService(ServletResolver.class);
        RequestProgressTracker tracker = TagUtil.getRequest(this.pageContext).getRequestProgressTracker();
        String servletName = null;
        if (!this.ignoreComponentHierarchy) {
            Resource resource = bindings.getResource();
            servlet = servletResolver.resolveServlet(resource, this.script);
            if (servlet != null) {
                servletName = RequestUtil.getServletName(servlet);
                tracker.log("Including script {0} for path={1}, type={2}: {3}", this.script, resource.getPath(), resource.getResourceType(), servletName);
            }
        } else {
            String scriptPath;
            ResourceResolver rr = bindings.getRequest().getResourceResolver();
            if (!this.script.startsWith("/")) {
                String parentPath = ResourceUtil.getParent(scriptHelper.getScript().getScriptResource().getPath());
                for (String sp : rr.getSearchPath()) {
                    if (!parentPath.startsWith(sp)) continue;
                    parentPath = parentPath.substring(sp.length());
                    break;
                }
                scriptPath = parentPath + "/" + this.script;
            } else {
                scriptPath = this.script;
            }
            servlet = servletResolver.resolveServlet(rr, scriptPath);
            if (servlet != null) {
                servletName = RequestUtil.getServletName(servlet);
                tracker.log("Including script {0} (ignoring component hierarchy): {1}", this.script, servletName);
            }
        }
        if (servlet == null) {
            throw new JspException("Could not find script " + this.script);
        }
        try {
            if (this.flush && !(this.pageContext.getOut() instanceof BodyContent)) {
                this.pageContext.getOut().flush();
            }
            JspSlingHttpServletResponseWrapper response = new JspSlingHttpServletResponseWrapper(this.pageContext);
            tracker.startTimer(servletName);
            servlet.service(this.pageContext.getRequest(), (ServletResponse)response);
            tracker.logTimer(servletName);
            return 6;
        }
        catch (Exception e) {
            log.error("Error while executing script " + this.script, (Throwable)e);
            throw new JspException("Error while executing script " + this.script, (Throwable)e);
        }
    }

    private int includeResource() throws JspException {
        RequestDispatcherOptions opts = new RequestDispatcherOptions();
        SlingHttpServletRequest request = TagUtil.getRequest(this.pageContext);
        Resource resource = request.getResource();
        if (this.resourceType.startsWith("./") || this.resourceType.startsWith("../")) {
            this.resourceType = ResourceUtil.normalize(resource.getResourceType() + "/" + this.resourceType);
        }
        if (!this.path.startsWith("/")) {
            this.path = resource.getPath() + "/" + this.path;
        }
        this.path = ResourceUtil.normalize(this.path);
        resource = request.getResourceResolver().resolve(this.path);
        if (resource instanceof NonExistingResource) {
            resource = new SyntheticResource(request.getResourceResolver(), this.path, this.resourceType);
        } else {
            opts.setForceResourceType(this.resourceType);
        }
        try {
            RequestDispatcher dispatcher;
            if (this.flush && !(this.pageContext.getOut() instanceof BodyContent)) {
                this.pageContext.getOut().flush();
            }
            if ((dispatcher = request.getRequestDispatcher(resource, opts)) != null) {
                JspSlingHttpServletResponseWrapper response = new JspSlingHttpServletResponseWrapper(this.pageContext);
                dispatcher.include((ServletRequest)request, (ServletResponse)response);
            } else {
                TagUtil.log(log, this.pageContext, "No content to include...", null);
            }
        }
        catch (IOException ioe) {
            throw new JspException("Error including " + this.path, (Throwable)ioe);
        }
        catch (ServletException ce) {
            throw new JspException("Error including " + this.path, TagUtil.getRootCause(ce));
        }
        return 6;
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.resourceType = null;
        this.path = null;
        this.script = null;
        this.flush = false;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setFlush(boolean flush) {
        this.flush = flush;
    }

    public void setIgnoreComponentHierarchy(boolean ignoreComponentHierarchy) {
        this.ignoreComponentHierarchy = ignoreComponentHierarchy;
    }
}

