/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.tags;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class RequestURLTag
extends TagSupport {
    private static final long serialVersionUID = -5674803762870190034L;
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private String uri;

    public RequestURLTag() {
        this.init();
    }

    public void removeParam(String name) {
        this.parameters.remove(name);
    }

    public void removeParam(String name, String value) {
        List<String> values = this.parameters.get(name);
        if (values != null) {
            values.remove(value);
            if (values.size() == 0) {
                this.parameters.remove(name);
            }
        }
    }

    public void addParam(String name, String value) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.parameters.put(name, values);
        }
        values.add(value);
    }

    public void release() {
        this.init();
        super.release();
    }

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        this.uri = request.getRequestURI();
        Iterator i$ = request.getParameterMap().entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            ArrayList<String> values = new ArrayList<String>();
            values.addAll(Arrays.asList((String[])entry.getValue()));
            this.parameters.put((String)entry.getKey(), values);
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.print(this.uri);
            String separator = "?";
            for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
                String name = entry.getKey();
                List<String> values = entry.getValue();
                for (String value : values) {
                    out.print(separator);
                    separator = "&";
                    out.print(URLEncoder.encode(name, "UTF-8"));
                    out.print("=");
                    out.print(URLEncoder.encode(value, "UTF-8"));
                }
            }
            int n = super.doEndTag();
            return n;
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.init();
        }
    }

    private void init() {
        this.parameters.clear();
        this.uri = null;
    }
}

