/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.tags;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.DiffInfo;
import com.day.cq.commons.DiffService;
import com.day.cq.wcm.api.WCMMode;
import java.io.IOException;
import java.text.Format;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.TagUtil;

public class TextTag
extends BodyTagSupport {
    public static final String DEFAULT_PLACEHOLDER = "<div><span class=\"cq-text-placeholder-ipe\">&para;</span></div>";
    private Object value;
    private Object oldValue;
    private String def;
    private String placeholder;
    private String propertyName;
    private Format fmt;
    private boolean escapeXml;
    private boolean noDiff;
    private String output;
    private String tagClass;
    private String tagName;
    private static String PROPERTY_TEXT_IS_RICH = "textIsRich";
    private XSSAPI xssAPI;
    private boolean textIsRich;

    private void init() {
        this.value = null;
        this.oldValue = null;
        this.def = null;
        this.placeholder = DEFAULT_PLACEHOLDER;
        this.propertyName = null;
        this.noDiff = false;
        this.fmt = null;
        this.output = null;
        this.escapeXml = false;
        this.tagName = null;
        this.tagClass = null;
    }

    public void release() {
        super.release();
        this.init();
    }

    public int doStartTag() throws JspException {
        DiffInfo diffInfo;
        this.bodyContent = null;
        this.output = null;
        if (this.placeholder == null) {
            this.placeholder = DEFAULT_PLACEHOLDER;
        }
        if (this.value != null) {
            this.output = String.valueOf(this.value);
        }
        Resource resource = TagUtil.getRequest(this.pageContext).getResource();
        if (this.output == null && this.propertyName != null) {
            this.output = (String)((Object)ResourceUtil.getValueMap(resource).get(this.propertyName, String.class));
        }
        this.xssAPI = TagUtil.getRequest(this.pageContext).getResourceResolver().adaptTo(XSSAPI.class);
        this.textIsRich = ResourceUtil.getValueMap(TagUtil.getRequest(this.pageContext).getResource()).get(PROPERTY_TEXT_IS_RICH, false);
        if (resource != null && !this.noDiff && (diffInfo = resource.adaptTo(DiffInfo.class)) != null) {
            SlingBindings bindings = (SlingBindings)this.pageContext.getRequest().getAttribute(SlingBindings.class.getName());
            DiffService diffService = bindings.getSling().getService(DiffService.class);
            String oriText = null;
            if (this.oldValue != null) {
                oriText = String.valueOf(this.oldValue);
            } else if (this.propertyName != null) {
                ValueMap map = ResourceUtil.getValueMap(diffInfo.getContent());
                oriText = map.get(this.propertyName, "");
            }
            String output_escaped = this.escapeXml ? this.escapeXSS(this.output) : this.output;
            String oritext_escaped = this.escapeXml ? this.escapeXSS(oriText) : oriText;
            String diffOutput = diffInfo.getDiffOutput(diffService, output_escaped, oritext_escaped, !this.escapeXml);
            if (diffOutput != null) {
                this.output = diffOutput;
                this.escapeXml = false;
            }
        }
        if (this.output != null) {
            return 0;
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        this.output = this.bodyContent.getString().trim();
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.output != null && this.fmt != null) {
                this.output = this.fmt.format(this.output);
            }
            if (this.output != null && this.escapeXml) {
                this.output = this.escapeXSS(this.output);
            }
            if (this.output == null || this.output.length() == 0) {
                this.output = WCMMode.fromRequest(this.pageContext.getRequest()) == WCMMode.EDIT ? this.placeholder : this.def;
            }
            if (this.output != null && this.output.length() > 0) {
                if (this.tagClass != null || this.tagName != null) {
                    if (this.tagName == null) {
                        this.tagName = "div";
                    }
                    this.pageContext.getOut().write("<");
                    this.pageContext.getOut().write(this.tagName);
                    if (this.tagClass != null && this.tagClass.length() > 0) {
                        this.pageContext.getOut().write(" class=\"");
                        this.pageContext.getOut().write(this.tagClass);
                        this.pageContext.getOut().write("\"");
                    }
                    this.pageContext.getOut().write(">");
                }
                this.pageContext.getOut().write(this.output);
                if (this.tagName != null) {
                    this.pageContext.getOut().write("</");
                    this.pageContext.getOut().write(this.tagName);
                    this.pageContext.getOut().write(">");
                }
            }
        }
        catch (IOException e) {
            throw new JspTagException((Throwable)e);
        }
        return 6;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setDefault(String def) {
        this.def = def;
    }

    public void setProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setFormat(Format fmt) {
        this.fmt = fmt;
    }

    public void setEscapeXml(boolean escapeXml) {
        this.escapeXml = escapeXml;
    }

    public void setNoDiff(boolean noDiff) {
        this.noDiff = noDiff;
    }

    public void setPlaceholder(String def) {
        this.placeholder = def;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public void setTagClass(String tagClass) {
        this.tagClass = tagClass;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    private String escapeXSS(String text) {
        if (this.textIsRich) {
            return this.xssAPI.filterHTML(text);
        }
        return this.xssAPI.encodeForHTML(text);
    }
}

