/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.packaging;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONResponse {
    private static final Logger log = LoggerFactory.getLogger(JSONResponse.class);
    public static final String TEXT_HTML_UTF8 = "text/html; charset=utf-8";
    public static final String APPLICATION_JSON_UTF8 = "application/json; charset=utf-8";
    private int status = 200;
    private boolean success = true;
    private String message = "";
    private String path = "";
    private String data = "";
    private String location = "";
    private String contentType = "application/json; charset=utf-8";
    private boolean jsonInTextarea = false;

    public JSONResponse() {
    }

    public JSONResponse(boolean success, String message) {
        this.success = success;
        this.message = message;
        this.status = success ? 200 : 500;
    }

    public JSONResponse(boolean success, String message, String path) {
        this.success = success;
        this.message = message;
        this.status = success ? 200 : 500;
        this.path = path;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void writeJsonInTextarea(boolean v) {
        if (v) {
            this.contentType = TEXT_HTML_UTF8;
            this.jsonInTextarea = true;
        }
    }

    public void send(HttpServletResponse response, boolean setStatus) throws IOException {
        if (setStatus) {
            response.setStatus(this.status);
            if (this.status == 201) {
                response.setHeader("Location", this.location);
            }
        }
        response.setContentType(this.contentType);
        PrintWriter out = response.getWriter();
        if (this.jsonInTextarea) {
            out.print("<textarea>");
        }
        JSONWriter w = new JSONWriter(out);
        try {
            w.object();
            w.key("success").value(this.success);
            if (this.message.length() > 0) {
                w.key("msg").value(this.message);
            }
            if (this.path.length() > 0) {
                w.key("path").value(this.path);
            }
            if (this.data.length() > 0) {
                w.key("data").value(this.data);
            }
            if (this.location.length() > 0) {
                w.key("location").value(this.location);
            }
            w.endObject();
        }
        catch (JSONException e) {
            log.error("Error while writing json.");
            throw new IOException(e.toString());
        }
        if (this.jsonInTextarea) {
            out.print("</textarea>");
        }
    }
}

