/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sc.qom;

import com.day.crx.sc.qom.AbstractQuery;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.query.qom.And;
import javax.jcr.query.qom.BindVariableValue;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Comparison;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Not;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;

public abstract class AbstractQueryObjectModel
extends AbstractQuery
implements QueryObjectModel {
    private final Source source;
    private final Constraint constraint;
    private final Ordering[] orderings;
    private final Column[] columns;

    protected AbstractQueryObjectModel(Source source, Constraint constraint, Ordering[] orderings, Column[] columns) {
        super(null, "JCR-JQOM", AbstractQueryObjectModel.getBindVariableNames(constraint));
        this.source = source;
        this.constraint = constraint;
        this.orderings = orderings;
        this.columns = columns;
    }

    @Override
    public String getStatement() {
        return null;
    }

    public Source getSource() {
        return this.source;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public Ordering[] getOrderings() {
        return this.orderings;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    private static String[] getBindVariableNames(Constraint constraint) {
        HashSet<String> names = new HashSet<String>();
        AbstractQueryObjectModel.collectBindVariableNames(names, constraint);
        return names.toArray(new String[names.size()]);
    }

    private static void collectBindVariableNames(Set<String> names, Constraint constraint) {
        if (constraint instanceof And) {
            And and = (And)constraint;
            AbstractQueryObjectModel.collectBindVariableNames(names, and.getConstraint1());
            AbstractQueryObjectModel.collectBindVariableNames(names, and.getConstraint2());
        } else if (constraint instanceof Or) {
            Or or = (Or)constraint;
            AbstractQueryObjectModel.collectBindVariableNames(names, or.getConstraint1());
            AbstractQueryObjectModel.collectBindVariableNames(names, or.getConstraint2());
        } else if (constraint instanceof Not) {
            Not not = (Not)constraint;
            AbstractQueryObjectModel.collectBindVariableNames(names, not.getConstraint());
        } else if (constraint instanceof Comparison) {
            BindVariableValue bvv;
            Comparison comp = (Comparison)constraint;
            DynamicOperand op1 = comp.getOperand1();
            StaticOperand op2 = comp.getOperand2();
            if (op1 instanceof BindVariableValue) {
                bvv = (BindVariableValue)op1;
                names.add(bvv.getBindVariableName());
            }
            if (op2 instanceof BindVariableValue) {
                bvv = (BindVariableValue)op2;
                names.add(bvv.getBindVariableName());
            }
        } else if (constraint instanceof BindVariableValue) {
            BindVariableValue bvv = (BindVariableValue)constraint;
            names.add(bvv.getBindVariableName());
        }
    }
}

