/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sc.qom;

import com.day.crx.sc.qom.JoinMerger;
import com.day.crx.sc.qom.OperandEvaluator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.EquiJoinCondition;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.Operand;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.StaticOperand;

class EquiJoinMerger
extends JoinMerger {
    private final PropertyValue leftProperty;
    private final PropertyValue rightProperty;

    public EquiJoinMerger(Join join, Map<String, PropertyValue> columns, OperandEvaluator evaluator, QueryObjectModelFactory factory, EquiJoinCondition condition) throws RepositoryException {
        super(join, columns, evaluator, factory);
        PropertyValue property1 = factory.propertyValue(condition.getSelector1Name(), condition.getProperty1Name());
        PropertyValue property2 = factory.propertyValue(condition.getSelector2Name(), condition.getProperty2Name());
        if (this.leftSelectors.contains(property1.getSelectorName()) && this.rightSelectors.contains(property2.getSelectorName())) {
            this.leftProperty = property1;
            this.rightProperty = property2;
        } else if (this.leftSelectors.contains(property2.getSelectorName()) && this.rightSelectors.contains(property1.getSelectorName())) {
            this.leftProperty = property2;
            this.rightProperty = property1;
        } else {
            throw new RepositoryException("Invalid equi-join");
        }
    }

    @Override
    public Set<String> getLeftValues(Row row) throws RepositoryException {
        return this.getValues(this.leftProperty, row);
    }

    @Override
    public Set<String> getRightValues(Row row) throws RepositoryException {
        return this.getValues(this.rightProperty, row);
    }

    @Override
    public List<Constraint> getRightJoinConstraints(List<Row> leftRows) throws RepositoryException {
        HashMap<String, Literal> literals = new HashMap<String, Literal>();
        for (Row leftRow : leftRows) {
            for (Value value : this.evaluator.getValues((Operand)this.leftProperty, leftRow)) {
                literals.put(value.getString(), this.factory.literal(value));
            }
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>(literals.size());
        for (Literal literal : literals.values()) {
            constraints.add((Constraint)this.factory.comparison((DynamicOperand)this.rightProperty, "jcr.operator.equal.to", (StaticOperand)literal));
        }
        return constraints;
    }

    private Set<String> getValues(PropertyValue property, Row row) throws RepositoryException {
        HashSet<String> strings = new HashSet<String>();
        for (Value value : this.evaluator.getValues((Operand)property, row)) {
            strings.add(value.getString());
        }
        return strings;
    }
}

