/*
 * Decompiled with CFR 0.152.
 */
package com.day.imageio.plugins;

import javax.imageio.metadata.IIOMetadata;
import org.w3c.dom.Node;

public class GIFStreamMetadata
extends IIOMetadata {
    public static final String[] versionStrings = new String[]{"87a", "89a"};
    public String version;
    public int logicalScreenWidth;
    public int logicalScreenHeight;
    public int colorResolution;
    public int pixelAspectRatio;
    public int backgroundColorIndex;
    public boolean sortFlag;
    public static final String[] colorTableSizes = new String[]{"2", "4", "8", "16", "32", "64", "128", "256"};
    public byte[] globalColorTable = null;
    public ApplicationExtension[] extensions = null;
    private int loopAE = -1;

    public GIFStreamMetadata() {
        super(false, null, null, null, null);
    }

    public boolean isReadOnly() {
        return true;
    }

    public Node getAsTree(String formatName) {
        throw new IllegalArgumentException("Not a recognized format!");
    }

    public void setFromTree(String formatName, Node root) {
        throw new IllegalStateException("Metadata is read-only!");
    }

    public void mergeTree(String formatName, Node root) {
        throw new IllegalStateException("Metadata is read-only!");
    }

    public void reset() {
        throw new IllegalStateException("Metadata is read-only!");
    }

    public final void setLoops(int loops) {
        if (loops < 0) {
            this.removeLoops();
        }
        if (this.loopAE < 0) {
            if (this.extensions == null) {
                this.extensions = new ApplicationExtension[1];
            } else {
                ApplicationExtension[] tmp = new ApplicationExtension[this.extensions.length + 1];
                System.arraycopy(this.extensions, 0, tmp, 0, this.extensions.length);
            }
            this.loopAE = this.extensions.length - 1;
            this.extensions[this.loopAE] = new ApplicationExtension();
            this.extensions[this.loopAE].identifier = "NETSCAPE".getBytes();
            this.extensions[this.loopAE].authCode = "2.0".getBytes();
            this.extensions[this.loopAE].subBlocks = new byte[1][3];
            this.extensions[this.loopAE].subBlocks[0][0] = 1;
        }
        this.extensions[this.loopAE].subBlocks[0][1] = (byte)(loops & 0xFF);
        this.extensions[this.loopAE].subBlocks[0][2] = (byte)(loops >> 8 & 0xFF);
    }

    public void removeLoops() {
        if (this.loopAE >= 0) {
            if (this.extensions.length == 1) {
                this.extensions = null;
            } else {
                ApplicationExtension[] tmp = new ApplicationExtension[this.extensions.length - 1];
                int i = 0;
                int j = 0;
                while (j < tmp.length) {
                    if (i == this.loopAE) {
                        ++i;
                        continue;
                    }
                    tmp[j++] = this.extensions[i++];
                }
            }
            this.loopAE = -1;
        }
    }

    public final class ApplicationExtension {
        byte[] identifier;
        byte[] authCode;
        byte[][] subBlocks;
    }
}

