/*
 * Decompiled with CFR 0.152.
 */
package com.day.io;

public class ByteBuffer {
    private int length = 0;
    private Chunk firstChunk;
    private Chunk lastChunk;

    public ByteBuffer() {
        this.reset();
    }

    public void reset() {
        this.firstChunk = this.lastChunk = new Chunk();
        this.length = 0;
    }

    public byte[] get() {
        byte[] ret = new byte[this.length];
        this.get(ret, 0, this.length);
        return ret;
    }

    public byte[] get(int num) {
        byte[] ret = new byte[Math.min(num, this.length)];
        this.get(ret, 0, ret.length);
        return ret;
    }

    public int get(byte[] output, int offset, int num) {
        if (num > this.length) {
            num = this.length;
        }
        int total = num;
        while (num > 0) {
            int rd = this.firstChunk.get(output, offset, num);
            offset += rd;
            num -= rd;
            this.length -= rd;
            if (!this.firstChunk.isEmpty() || this.firstChunk.next == null) continue;
            this.firstChunk = this.firstChunk.next;
        }
        return total;
    }

    public void put(byte[] input, int offset, int len) {
        if (len > 0) {
            this.lastChunk = this.lastChunk.put(input, offset, len);
            this.length += len;
        }
    }

    public void put(byte[] bytes) {
        if (bytes != null) {
            this.put(bytes, 0, bytes.length);
        }
    }

    public void put(byte b) {
        this.lastChunk = this.lastChunk.put(b);
        ++this.length;
    }

    public int length() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    private static class Chunk {
        private static final int SIZE = 4096;
        private byte[] bytes;
        private int start;
        private int end;
        private Chunk next;

        private Chunk() {
            this(null, 0, 0);
        }

        private Chunk(byte b) {
            this(null, 0, 0);
            this.bytes[this.start] = b;
            ++this.end;
        }

        private Chunk(byte[] input) {
            this(input, 0, input.length);
        }

        private Chunk(byte[] input, int offset, int len) {
            this.bytes = new byte[Math.max(len, 4096)];
            this.start = 0;
            this.end = len;
            if (len > 0) {
                System.arraycopy(input, offset, this.bytes, 0, len);
            }
        }

        private int get(byte[] output, int offset, int len) {
            if (len > this.length()) {
                len = this.length();
            }
            System.arraycopy(this.bytes, this.start, output, offset, len);
            this.start += len;
            if (this.start == this.end) {
                this.end = 0;
                this.start = 0;
            }
            return len;
        }

        private Chunk put(byte[] input, int offset, int len) {
            if (len < this.bytes.length - this.end) {
                System.arraycopy(input, offset, this.bytes, this.end, len);
                this.end += len;
                return this;
            }
            int num = this.bytes.length - this.end;
            System.arraycopy(input, offset, this.bytes, this.end, num);
            this.end = this.bytes.length;
            Chunk cnk = new Chunk(input, offset + num, len - num);
            cnk.next = this.next;
            this.next = cnk;
            return cnk;
        }

        private Chunk put(byte b) {
            if (1 < this.bytes.length - this.end) {
                this.bytes[this.end++] = b;
                return this;
            }
            Chunk cnk = new Chunk(b);
            cnk.next = this.next;
            this.next = cnk;
            return cnk;
        }

        private boolean isEmpty() {
            return this.start == this.end;
        }

        private int length() {
            return this.end - this.start;
        }
    }
}

