/*
 * Decompiled with CFR 0.152.
 */
package com.day.io;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.Writer;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IO {
    private static final Logger log = LoggerFactory.getLogger((Class)IO.class);
    private static final String TEMPDIR = "tmp";
    private static File tempDir;
    private static File cwd;

    public static int spool(InputStream in, OutputStream out) throws IOException {
        int rd;
        byte[] buffer = new byte[8192];
        int total = 0;
        while ((rd = in.read(buffer)) > 0) {
            out.write(buffer, 0, rd);
            total += rd;
        }
        return total;
    }

    public static int spool(InputStream in, byte[] buffer) throws IOException {
        int total;
        int rd;
        for (total = 0; total < buffer.length && (rd = in.read(buffer, total, buffer.length - total)) >= 0; total += rd) {
        }
        return total;
    }

    public static int spool(Reader in, Writer out) throws IOException {
        int rd;
        char[] buffer = new char[8192];
        int total = 0;
        while (in.ready() && (rd = in.read(buffer)) > 0) {
            out.write(buffer, 0, rd);
            total += rd;
        }
        return total;
    }

    public static int spool(InputStream in, OutputStream out, int num) throws IOException {
        byte[] buffer = new byte[8192];
        int rd = 0;
        int total = num;
        while (num > 0 && rd >= 0) {
            rd = in.read(buffer, 0, num > buffer.length ? buffer.length : num);
            if (rd <= 0) continue;
            out.write(buffer, 0, rd);
            num -= rd;
        }
        return total - num;
    }

    public static void tryClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void tryClose(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void tryClose(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void tryClose(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rename0(File src, File dst) {
        if (dst.exists()) {
            dst.delete();
        }
        dst.getParentFile().mkdirs();
        if (!src.renameTo(dst)) {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(src);
                out = new FileOutputStream(dst);
                IO.spool((InputStream)in, out);
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (!src.delete()) {
                try {
                    new FileOutputStream(src).close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                src.deleteOnExit();
            }
        }
        return true;
    }

    public static String readUTF(InputStream in) throws UTFDataFormatException, IOException {
        int c;
        CharArrayWriter out = new CharArrayWriter(256);
        block5: while ((c = in.read()) != -1) {
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    out.write(c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int char2 = in.read();
                    if (char2 == -1) {
                        throw new UTFDataFormatException("unexpected end of input");
                    }
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("consecutive byte should have bit 6 cleared");
                    }
                    out.write((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    int char2 = in.read();
                    if (char2 == -1) {
                        throw new UTFDataFormatException("unexpected end of input");
                    }
                    int char3 = in.read();
                    if (char3 == -1) {
                        throw new UTFDataFormatException("unexpected end of input");
                    }
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("consecutive byte should have bit 6 cleared");
                    }
                    out.write((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    continue block5;
                }
            }
            throw new UTFDataFormatException("invalid UTF-8 byte");
        }
        return out.toString();
    }

    public static void setCWD(File cwd) {
        if (IO.cwd == null) {
            IO.cwd = cwd;
            IO.setTempDir(IO.getAbsoluteFile(TEMPDIR));
        } else {
            Exception e = new Exception("Caller stack trace");
            log.warn("Attempt to initialize IO twice", (Throwable)e);
        }
    }

    public static void setCQ3Home(File cq3Home) {
        IO.setCWD(cq3Home);
    }

    public static void setTempDir(File tempDir) {
        if (IO.tempDir == null) {
            IO.tempDir = tempDir;
            IO.tempDir.mkdirs();
        } else {
            Exception e = new Exception("Caller stack trace");
            log.warn("Attempt to initialize IO twice", (Throwable)e);
        }
    }

    public static File getTempDir() {
        if (tempDir == null) {
            throw new InternalError("IO has not been initialized");
        }
        return tempDir;
    }

    public static String getAppHome() {
        return IO.getCWD().getPath();
    }

    public static File getAppHomeDirectory() {
        return IO.getCWD();
    }

    public static File getCWD() {
        if (cwd == null) {
            throw new InternalError("IO has not been initialized");
        }
        return cwd;
    }

    public static File getCanonicalFile(String path) {
        try {
            path = path.replace('/', File.separatorChar);
            return new File(path).getCanonicalFile();
        }
        catch (IOException e) {
            log.warn("Unable to canonicalize path: {}", (Object)path);
            return null;
        }
    }

    public static boolean isParent(File parent, File child) {
        if (!parent.isAbsolute() || !child.isAbsolute()) {
            throw new IllegalArgumentException("parent and child must be absolute");
        }
        while (child != null) {
            if (parent.equals(child)) {
                return true;
            }
            child = child.getParentFile();
        }
        return false;
    }

    public static File createTempFile(Collection tracker) throws IOException {
        return IO.createTempFile(tracker, "cq3", "");
    }

    public static File createTempFile(Collection tracker, String prefix, String suffix) throws IOException {
        if (tracker == null) {
            throw new IllegalArgumentException("context == null");
        }
        File tempFile = File.createTempFile(prefix, suffix, IO.getTempDir());
        tracker.add(tempFile);
        return tempFile;
    }

    public static File createTempFile() throws IOException {
        return IO.createTempFile("cq3", "");
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, IO.getTempDir());
    }

    public static String getAbsolutePath(String path) {
        return IO.getAbsoluteFile(path).getPath();
    }

    public static File getAbsoluteFile(String path) {
        File file;
        if (path == null) {
            path = "";
        }
        if (!(file = new File(path = path.replace('/', File.separatorChar))).isAbsolute()) {
            file = new File(IO.getCWD(), path);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rename(File src, File dst) {
        if (dst.exists() && !dst.delete()) {
            log.warn("Error while deleting destination file {}. might be in use.", (Object)dst.getPath());
        }
        dst.getParentFile().mkdirs();
        if (!src.renameTo(dst)) {
            log.warn("Error while renaming {} to {}. Copying content.", (Object)src.getPath(), (Object)dst.getPath());
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(src);
                out = new FileOutputStream(dst);
                IO.spool((InputStream)in, out);
            }
            catch (IOException e) {
                log.error("Error while spooling {} to {}: {}", new Object[]{src.getPath(), dst.getPath(), e.getMessage()});
                boolean bl = false;
                return bl;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (!src.delete()) {
                log.warn("Error while deleting src after spool {}", (Object)src.getPath());
                try {
                    new FileOutputStream(src).close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                src.deleteOnExit();
            }
        }
        return true;
    }
}

