/*
 * Decompiled with CFR 0.152.
 */
package com.day.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import sun.io.ByteToCharConverter;

public class WriterOutputStream
extends OutputStream {
    private Writer out;
    private ByteToCharConverter btc;

    public WriterOutputStream(Writer writer, String encoding) throws UnsupportedEncodingException {
        this.out = writer;
        this.btc = ByteToCharConverter.getConverter((String)encoding);
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int estCount = this.btc.getMaxCharsPerByte() * len;
        char[] buffer = new char[estCount];
        int written = this.btc.convert(b, off, len + off, buffer, 0, buffer.length);
        this.out.write(buffer, 0, written);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void flush() throws IOException {
        char[] buffer = new char[8192];
        int written = this.btc.flush(buffer, 0, buffer.length);
        this.out.write(buffer, 0, written);
        this.out.flush();
    }
}

