/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.util;

import java.io.IOException;
import java.io.OutputStream;

public class LineOutputStream
extends OutputStream {
    public static final byte[] LS_BINARY = null;
    public static final byte[] LS_UNIX = new byte[]{10};
    public static final byte[] LS_WINDOWS = new byte[]{13, 10};
    public static final byte[] LS_NATIVE = System.getProperty("line.separator").getBytes();
    private byte[] buffer = new byte[8192];
    private byte[] lineFeed = LS_NATIVE;
    private int pos = 0;
    private static final char STATE_INIT = ' ';
    private static final char STATE_CR = 'c';
    private static final char STATE_LF = 'l';
    private static final char STATE_CRLF = 'f';
    private char state = (char)32;
    private final OutputStream out;

    public LineOutputStream(OutputStream out, byte[] ls) {
        this.out = out;
        if (ls != null) {
            this.lineFeed = ls;
        }
    }

    public void write(int b) throws IOException {
        if (b == 10) {
            switch (this.state) {
                case ' ': {
                    this.state = (char)108;
                    break;
                }
                case 'c': {
                    this.state = (char)102;
                    break;
                }
                case 'l': {
                    this.flush(true);
                    this.state = (char)108;
                    break;
                }
                case 'f': {
                    this.flush(true);
                    this.state = (char)108;
                }
            }
        } else if (b == 13) {
            switch (this.state) {
                case ' ': {
                    this.state = (char)99;
                    break;
                }
                case 'l': {
                    this.state = (char)102;
                    break;
                }
                case 'c': {
                    this.flush(true);
                    this.state = (char)99;
                    break;
                }
                case 'f': {
                    this.flush(true);
                    this.state = (char)99;
                }
            }
        } else {
            if (this.state != ' ') {
                this.flush(true);
                this.state = (char)32;
            }
            if (this.pos == this.buffer.length) {
                this.flush();
            }
            this.buffer[this.pos++] = (byte)(b & 0xFF);
        }
    }

    public void flush(boolean addLF) throws IOException {
        this.flush();
        if (addLF) {
            this.out.write(this.lineFeed);
        }
        this.out.flush();
    }

    public void flush() throws IOException {
        this.out.write(this.buffer, 0, this.pos);
        this.pos = 0;
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush(this.state != ' ');
        this.out.close();
    }
}

