/*
 * Decompiled with CFR 0.152.
 */
package com.day.text;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class StringTable {
    protected static final String EMPTY_STRING = "";
    protected static final int DELIM_TYPE_NONE = 0;
    protected static final int DELIM_TYPE_COL = 1;
    protected static final int DELIM_TYPE_ROW = 2;
    protected static final int DELIM_TYPE_CR = 4;
    private String[][] table;
    private int numRows;
    private int numCols;

    protected StringTable(int numRows, int numCols, List rowList) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.table = new String[numRows][numCols];
        Iterator rowIter = rowList.iterator();
        int row = 0;
        while (rowIter.hasNext()) {
            List colList = (List)rowIter.next();
            colList.toArray(this.table[row]);
            for (int col = colList.size(); col < numCols; ++col) {
                this.table[row][col] = EMPTY_STRING;
            }
            ++row;
        }
    }

    public static StringTable fromString(String srcString, String delims) {
        return StringTable.fromString(srcString, delims, true);
    }

    public static StringTable fromString(String srcString, String delims, boolean preserveEmptyRows) {
        int maxCols = -1;
        delims = delims + "\r\n";
        StringTokenizer tokener = new StringTokenizer(srcString, delims, true);
        int delim = 2;
        LinkedList rowList = new LinkedList();
        LinkedList<String> colList = new LinkedList<String>();
        while (tokener.hasMoreTokens()) {
            String tok = tokener.nextToken();
            if (tok.length() == 1 && delims.indexOf(tok.charAt(0)) >= 0) {
                char d = tok.charAt(0);
                if (d == '\r' || d == '\n') {
                    if (d != '\n' || delim != 4) {
                        if (colList.size() > 0 || preserveEmptyRows) {
                            rowList.add(colList);
                            if (colList.size() > maxCols) {
                                maxCols = colList.size();
                            }
                        }
                        colList = new LinkedList();
                    }
                    delim = d == '\r' ? 4 : 2;
                    continue;
                }
                if (delim != 0) {
                    colList.add(EMPTY_STRING);
                }
                delim = 1;
                continue;
            }
            if (colList == null) {
                colList = new LinkedList();
            }
            colList.add(tok);
            delim = 0;
        }
        if (delim != 2 && delim != 4) {
            rowList.add(colList);
            if (colList.size() > maxCols) {
                maxCols = colList.size();
            }
        }
        return new StringTable(rowList.size(), maxCols, rowList);
    }

    public StringTable transpose() {
        String[][] tmpTab = new String[this.numCols][this.numRows];
        for (int row = 0; row < this.numRows; ++row) {
            for (int col = 0; col < this.numCols; ++col) {
                tmpTab[col][row] = this.table[row][col];
            }
        }
        this.table = tmpTab;
        int t = this.numRows;
        this.numRows = this.numCols;
        this.numCols = t;
        return this;
    }

    public String[][] getTable() {
        return this.table;
    }

    public int getRows() {
        return this.numRows;
    }

    public int getCols() {
        return this.numCols;
    }
}

