/*
 * Decompiled with CFR 0.152.
 */
package com.day.util.diff;

import com.day.util.diff.Document;
import com.day.util.diff.DocumentSource;
import com.day.util.diff.ElementsFactory;
import com.day.util.diff.FileDocumentSource;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class LineElementsFactory
implements ElementsFactory {
    static final String CVS_ID = "$URL$ $Rev$ $Date$";
    private static final int MAX_ELEMENTS = 100000;
    private final Document.Element[] elements;
    static /* synthetic */ Class class$com$day$util$diff$LineElementsFactory;

    private LineElementsFactory(Document.Element[] elements) {
        this.elements = elements;
    }

    public Document.Element[] getElements() {
        return this.elements;
    }

    public static LineElementsFactory create(DocumentSource source, String text, boolean ignoreWs) {
        try {
            StringReader reader = new StringReader(text);
            return LineElementsFactory.create(source, reader, ignoreWs);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static LineElementsFactory create(FileDocumentSource source, boolean ignoreWs) throws IOException {
        return LineElementsFactory.create((DocumentSource)source, (String)null, ignoreWs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LineElementsFactory create(FileDocumentSource source, boolean ignoreWs, String charset) throws IOException {
        InputStreamReader text = charset == null ? new FileReader(source.getFile()) : new InputStreamReader((InputStream)new FileInputStream(source.getFile()), charset);
        try {
            LineElementsFactory lineElementsFactory = LineElementsFactory.create((DocumentSource)source, text, ignoreWs);
            return lineElementsFactory;
        }
        finally {
            try {
                ((Reader)text).close();
            }
            catch (IOException e) {}
        }
    }

    public static LineElementsFactory create(DocumentSource source, Reader text, boolean ignoreWs) throws IOException {
        Document.Element[] elements = LineElementsFactory.getElements(source, text, ignoreWs);
        return new LineElementsFactory(elements);
    }

    private static Document.Element[] getElements(DocumentSource source, Reader r, boolean ignoreWS) throws IOException {
        if (r == null) {
            return new Document.Element[0];
        }
        ArrayList<Document.AnnotatedElement> lines = new ArrayList<Document.AnnotatedElement>();
        char[] buffer = new char[8192];
        int start = 0;
        int pos = 0;
        int end = r.read(buffer);
        while (pos < end) {
            char c;
            if ((c = buffer[pos++]) == '\n') {
                String line = new String(buffer, start, pos - start);
                if (ignoreWS) {
                    lines.add(new IStringElement(source, line));
                } else {
                    lines.add(new StringElement(source, line));
                }
                start = pos;
                if (lines.size() == 100000) break;
            }
            if (pos != end) continue;
            int len = end - start;
            if (len == buffer.length) {
                char[] newBuffer = new char[buffer.length * 2];
                System.arraycopy(buffer, start, newBuffer, 0, len);
                buffer = newBuffer;
            } else if (len > 0) {
                System.arraycopy(buffer, start, buffer, 0, len);
            }
            end = len;
            start = 0;
            pos = 0;
            int read = r.read(buffer, end, buffer.length - end);
            if (read < 0) break;
            end += read;
        }
        if (start < end) {
            String line = new String(buffer, start, end - start);
            if (ignoreWS) {
                lines.add(new IStringElement(source, line));
            } else {
                lines.add(new StringElement(source, line));
            }
        }
        if (ignoreWS) {
            return lines.toArray(new IStringElement[lines.size()]);
        }
        return lines.toArray(new StringElement[lines.size()]);
    }

    public static class IStringElement
    implements Document.AnnotatedElement {
        private final DocumentSource source;
        private final String string;
        private String stripped;
        static final /* synthetic */ boolean $assertionsDisabled;

        public DocumentSource getDocumentSource() {
            return this.source;
        }

        public String getString() {
            return this.string;
        }

        public IStringElement(DocumentSource source, String string) {
            this.source = source;
            this.string = string;
        }

        private String getStripped() {
            if (this.stripped == null) {
                StringBuffer buf = new StringBuffer(this.string.length());
                for (int i = 0; i < this.string.length(); ++i) {
                    char c = this.string.charAt(i);
                    if (Character.isWhitespace(c)) continue;
                    buf.append(c);
                }
                this.stripped = buf.toString();
            }
            return this.stripped;
        }

        public int hashCode() {
            return this.getStripped().hashCode();
        }

        public boolean equals(Object obj) {
            if (!$assertionsDisabled && !(obj instanceof IStringElement)) {
                throw new AssertionError();
            }
            return this.getStripped().equals(((IStringElement)obj).getStripped());
        }

        public String toString() {
            return this.string;
        }

        static {
            $assertionsDisabled = !(class$com$day$util$diff$LineElementsFactory == null ? (class$com$day$util$diff$LineElementsFactory = LineElementsFactory.class$("com.day.util.diff.LineElementsFactory")) : class$com$day$util$diff$LineElementsFactory).desiredAssertionStatus();
        }
    }

    public static class StringElement
    implements Document.AnnotatedElement {
        private final DocumentSource source;
        private final String string;

        public StringElement(DocumentSource source, String string) {
            this.source = source;
            this.string = string;
        }

        public String getString() {
            return this.string;
        }

        public DocumentSource getDocumentSource() {
            return this.source;
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public String toString() {
            return this.string;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof StringElement) {
                return ((StringElement)obj).string.equals(this.string);
            }
            return false;
        }
    }
}

