/*
 * Decompiled with CFR 0.152.
 */
package io.sightly.java.api;

import io.sightly.java.api.RuntimeExtension;
import io.sightly.java.api.RuntimeExtensionException;
import java.util.Dictionary;
import org.osgi.service.component.ComponentContext;

public abstract class ExtensionComponent
implements RuntimeExtension {
    public static final String NAME = "name";
    private String name;

    @Override
    public String name() {
        return this.name;
    }

    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        this.name = (String)properties.get(NAME);
    }

    protected void checkArgumentCount(Object[] arguments, int count) {
        if (arguments.length != count) {
            throw new RuntimeExtensionException(String.format("Extension %s requires %d arguments", this.name(), count));
        }
    }

    protected void checkArguments(Object[] arguments, Class<?> ... classes) {
        this.checkArgumentCount(arguments, classes.length);
        for (int i = 0; i < arguments.length; ++i) {
            Class<?> cls = classes[i];
            Object arg = arguments[i];
            if (cls.isAssignableFrom(arg.getClass())) continue;
            throw new RuntimeExtensionException(String.format("Argument on position %d is not of expected type %s", i, cls.getCanonicalName()));
        }
    }
}

