/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.kernel;

import com.google.common.base.Preconditions;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.kernel.BlobSerializer;
import org.apache.jackrabbit.oak.kernel.JsonFilter;
import org.apache.jackrabbit.oak.kernel.TypeCodes;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class JsonSerializer {
    private static final JsonFilter DEFAULT_FILTER = new JsonFilter("{\"properties\":[\"*\", \"-:childNodeCount\"]}");
    private final JsopBuilder json;
    private final int depth;
    private final long offset;
    private final int maxChildNodes;
    private final JsonFilter filter;
    private final BlobSerializer blobs;

    private JsonSerializer(JsopBuilder json, int depth, long offset, int maxChildNodes, JsonFilter filter, BlobSerializer blobs) {
        this.json = (JsopBuilder)Preconditions.checkNotNull((Object)json);
        this.depth = depth;
        this.offset = offset;
        this.maxChildNodes = maxChildNodes;
        this.filter = (JsonFilter)Preconditions.checkNotNull((Object)filter);
        this.blobs = (BlobSerializer)Preconditions.checkNotNull((Object)blobs);
    }

    JsonSerializer(int depth, long offset, int maxChildNodes, String filter, BlobSerializer blobs) {
        this(new JsopBuilder(), depth, offset, maxChildNodes, new JsonFilter(filter), blobs);
    }

    public JsonSerializer(JsopBuilder json, BlobSerializer blobs) {
        this(json, Integer.MAX_VALUE, 0L, Integer.MAX_VALUE, DEFAULT_FILTER, blobs);
    }

    protected JsonSerializer getChildSerializer() {
        return new JsonSerializer(this.json, this.depth - 1, 0L, this.maxChildNodes, this.filter, this.blobs);
    }

    /*
     * WARNING - void declaration
     */
    void serialize(NodeState node) {
        this.json.object();
        for (PropertyState propertyState : node.getProperties()) {
            String name = propertyState.getName();
            if (!this.filter.includeProperty(name)) continue;
            this.json.key(name);
            this.serialize(propertyState);
        }
        if (this.filter.includeProperty(":childNodeCount")) {
            this.json.key(":childNodeCount");
            this.json.value(node.getChildNodeCount(Integer.MAX_VALUE));
        }
        int index = 0;
        boolean bl = false;
        for (ChildNodeEntry childNodeEntry : node.getChildNodeEntries()) {
            void var3_6;
            String name = childNodeEntry.getName();
            if (!this.filter.includeNode(name) || (long)index++ < this.offset) continue;
            if (++var3_6 >= this.maxChildNodes) break;
            this.json.key(name);
            if (this.depth > 0) {
                this.getChildSerializer().serialize(childNodeEntry.getNodeState());
                continue;
            }
            this.json.object();
            this.json.endObject();
        }
        this.json.endObject();
    }

    public void serialize(PropertyState property) {
        Type<?> type = property.getType();
        if (!type.isArray()) {
            this.serialize(property, type, 0);
        } else {
            Type<?> base = type.getBaseType();
            int count = property.count();
            if (base == Type.STRING || count > 0) {
                this.json.array();
                for (int i = 0; i < count; ++i) {
                    this.serialize(property, base, i);
                }
                this.json.endArray();
            } else {
                this.json.value("[0]:" + PropertyType.nameFromValue((int)type.tag()));
            }
        }
    }

    void serialize(PropertyState property, Type<?> type, int index) {
        if (type == Type.BOOLEAN) {
            this.json.value(property.getValue(Type.BOOLEAN, index));
        } else if (type == Type.LONG) {
            this.json.value(property.getValue(Type.LONG, index));
        } else if (type == Type.DOUBLE) {
            Double value = property.getValue(Type.DOUBLE, index);
            if (value.isNaN() || value.isInfinite()) {
                this.json.value(TypeCodes.encode(type.tag(), value.toString()));
            } else {
                this.json.encodedValue(value.toString());
            }
        } else if (type == Type.BINARY) {
            Blob blob = property.getValue(Type.BINARY, index);
            this.json.value(TypeCodes.encode(type.tag(), this.blobs.serialize(blob)));
        } else {
            String value = property.getValue(Type.STRING, index);
            if (type != Type.STRING || TypeCodes.split(value) != -1) {
                value = TypeCodes.encode(type.tag(), value);
            }
            this.json.value(value);
        }
    }

    public String toString() {
        return this.json.toString();
    }
}

