/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.commit.AnnotatingConflictHandler;
import org.apache.jackrabbit.oak.plugins.commit.ConflictHook;
import org.apache.jackrabbit.oak.plugins.commit.ConflictValidatorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.CompositeHook;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.EditorHook;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncIndexUpdate
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AsyncIndexUpdate.class);
    private static final String ASYNC = ":async";
    private static final long DEFAULT_LIFETIME = TimeUnit.HOURS.toMillis(1L);
    private static final CommitFailedException CONCURRENT_UPDATE = new CommitFailedException("Async", 1, "Concurrent update detected");
    private static final int ASYNC_TIMEOUT = 15;
    private final String name;
    private final NodeStore store;
    private final IndexEditorProvider provider;
    private final long lifetime = DEFAULT_LIFETIME;
    private boolean failing = false;
    private final AsyncIndexStats indexStats = new AsyncIndexStats();
    private final boolean switchOnSync;
    private final Set<String> reindexedDefinitions = new HashSet<String>();

    public AsyncIndexUpdate(@Nonnull String name, @Nonnull NodeStore store, @Nonnull IndexEditorProvider provider, boolean switchOnSync) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.store = (NodeStore)Preconditions.checkNotNull((Object)store);
        this.provider = (IndexEditorProvider)Preconditions.checkNotNull((Object)provider);
        this.switchOnSync = switchOnSync;
    }

    public AsyncIndexUpdate(@Nonnull String name, @Nonnull NodeStore store, @Nonnull IndexEditorProvider provider) {
        this(name, store, provider, false);
    }

    @Override
    public synchronized void run() {
        CommitFailedException exception;
        block21: {
            log.debug("Running background index task {}", (Object)this.name);
            if (AsyncIndexUpdate.isAlreadyRunning(this.store, this.name)) {
                log.debug("Async job '{}' found to be already running. Skipping", (Object)this.name);
                return;
            }
            String checkpoint = this.store.checkpoint(this.lifetime);
            NodeState after = this.store.retrieve(checkpoint);
            if (after == null) {
                log.debug("Unable to retrieve checkpoint {}", (Object)checkpoint);
                return;
            }
            NodeBuilder builder = after.builder();
            NodeBuilder async = builder.child(ASYNC);
            NodeState before = null;
            PropertyState state = async.getProperty(this.name);
            if (state != null && state.getType() == Type.STRING) {
                before = this.store.retrieve(state.getValue(Type.STRING));
            }
            if (before == null) {
                before = EmptyNodeState.MISSING_NODE;
            }
            AsyncUpdateCallback callback = new AsyncUpdateCallback();
            AsyncIndexUpdate.preAsyncRunStatsStats(this.indexStats);
            IndexUpdate indexUpdate = new IndexUpdate(this.provider, this.name, after, builder, callback);
            exception = EditorDiff.process(indexUpdate, before, after);
            if (exception == null) {
                if (callback.dirty) {
                    block20: {
                        async.setProperty(this.name, checkpoint);
                        try {
                            this.store.merge(builder, AsyncIndexUpdate.newCommitHook(this.name, state), CommitInfo.EMPTY);
                        }
                        catch (CommitFailedException e) {
                            if (e == CONCURRENT_UPDATE) break block20;
                            exception = e;
                        }
                    }
                    if (this.switchOnSync) {
                        this.reindexedDefinitions.addAll(indexUpdate.getReindexedDefinitions());
                    } else {
                        AsyncIndexUpdate.postAsyncRunStatsStatus(this.indexStats);
                    }
                } else if (this.switchOnSync) {
                    log.debug("No changes detected after diff, will try to switch to synchronous updates on " + this.reindexedDefinitions);
                    async.setProperty(this.name, checkpoint);
                    for (String path : this.reindexedDefinitions) {
                        NodeBuilder c = builder;
                        for (String p : PathUtils.elements(path)) {
                            c = c.getChildNode(p);
                        }
                        if (!c.exists() || c.getBoolean("reindex")) continue;
                        c.removeProperty("async");
                    }
                    try {
                        this.store.merge(builder, AsyncIndexUpdate.newCommitHook(this.name, state), CommitInfo.EMPTY);
                        this.reindexedDefinitions.clear();
                        AsyncIndexUpdate.postAsyncRunStatsStatus(this.indexStats);
                    }
                    catch (CommitFailedException e) {
                        if (e == CONCURRENT_UPDATE) break block21;
                        exception = e;
                    }
                }
            }
        }
        if (exception != null) {
            if (!this.failing) {
                log.warn("Index update {} failed", (Object)this.name, (Object)exception);
            }
            this.failing = true;
        } else {
            if (this.failing) {
                log.info("Index update {} no longer fails", (Object)this.name);
            }
            this.failing = false;
        }
    }

    private static CommitHook newCommitHook(final String name, final PropertyState state) throws CommitFailedException {
        return new CompositeHook(new ConflictHook(new AnnotatingConflictHandler()), new EditorHook(new ConflictValidatorProvider()), new CommitHook(){

            @Override
            @Nonnull
            public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) throws CommitFailedException {
                PropertyState stateAfterRebase = before.getChildNode(AsyncIndexUpdate.ASYNC).getProperty(name);
                if (Objects.equal((Object)state, (Object)stateAfterRebase)) {
                    return AsyncIndexUpdate.postAsyncRunNodeStatus(after.builder(), name).getNodeState();
                }
                throw CONCURRENT_UPDATE;
            }
        });
    }

    private static void preAsyncRun(NodeStore store, String name) throws CommitFailedException {
        NodeBuilder builder = store.getRoot().builder();
        AsyncIndexUpdate.preAsyncRunNodeStatus(builder, name);
        store.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
    }

    private static boolean isAlreadyRunning(NodeStore store, String name) {
        NodeState indexState = store.getRoot().getChildNode("oak:index");
        if (!indexState.exists()) {
            return false;
        }
        if ("running".equals(indexState.getString(name + "-status"))) {
            PropertyState startTime = indexState.getProperty(name + "-start");
            Calendar start = Conversions.convert(startTime.getValue(Type.DATE)).toCalendar();
            Calendar now = Calendar.getInstance();
            long delta = now.getTimeInMillis() - start.getTimeInMillis();
            if (TimeUnit.MILLISECONDS.toMinutes(delta) > 15L) {
                log.info("Async job found which stated on {} has timed out in {} minutes. This node would take over the job.", (Object)startTime.getValue(Type.DATE), (Object)15);
                return false;
            }
            return true;
        }
        return false;
    }

    private static void preAsyncRunNodeStatus(NodeBuilder builder, String name) {
        String now = AsyncIndexUpdate.now();
        builder.getChildNode("oak:index").setProperty(name + "-status", "running").setProperty(name + "-start", now, Type.DATE).removeProperty(name + "-done");
    }

    private static void preAsyncRunStatsStats(AsyncIndexStats stats) {
        stats.start(AsyncIndexUpdate.now());
    }

    private static NodeBuilder postAsyncRunNodeStatus(NodeBuilder builder, String name) {
        String now = AsyncIndexUpdate.now();
        builder.getChildNode("oak:index").setProperty(name + "-status", "done").setProperty(name + "-done", now, Type.DATE).removeProperty(name + "-start");
        return builder;
    }

    private static void postAsyncRunStatsStatus(AsyncIndexStats stats) {
        stats.done(AsyncIndexUpdate.now());
    }

    private static String now() {
        return ISO8601.format(Calendar.getInstance());
    }

    public AsyncIndexStats getIndexStats() {
        return this.indexStats;
    }

    public boolean isFinished() {
        return this.indexStats.getStatus() == "done";
    }

    private static final class AsyncIndexStats
    implements IndexStatsMBean {
        private String start = "";
        private String done = "";
        private String status = "init";

        private AsyncIndexStats() {
        }

        public void start(String now) {
            this.status = "running";
            this.start = now;
            this.done = "";
        }

        public void done(String now) {
            this.status = "done";
            this.start = "";
            this.done = now;
        }

        @Override
        public String getStart() {
            return this.start;
        }

        @Override
        public String getDone() {
            return this.done;
        }

        @Override
        public String getStatus() {
            return this.status;
        }

        public String toString() {
            return "AsyncIndexStats [start=" + this.start + ", done=" + this.done + ", status=" + this.status + "]";
        }
    }

    private class AsyncUpdateCallback
    implements IndexUpdateCallback {
        private boolean dirty = false;

        private AsyncUpdateCallback() {
        }

        @Override
        public void indexUpdate() throws CommitFailedException {
            if (!this.dirty) {
                this.dirty = true;
                AsyncIndexUpdate.preAsyncRun(AsyncIndexUpdate.this.store, AsyncIndexUpdate.this.name);
            }
        }
    }
}

