/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.MultiLuceneIndex;
import org.apache.jackrabbit.oak.plugins.index.lucene.TermFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneIndexHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.MoreLikeThisHelper;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.fulltext.FullTextAnd;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextOr;
import org.apache.jackrabbit.oak.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndex
implements QueryIndex.FulltextQueryIndex {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneIndex.class);
    public static final String NATIVE_QUERY_FUNCTION = "native*lucene";
    static final int LUCENE_QUERY_BATCH_SIZE = 50;
    private final IndexTracker tracker;
    private final Analyzer analyzer;
    private final NodeAggregator aggregator;
    private static char[] fulltextTokens = new char[]{'*', '?'};

    public LuceneIndex(IndexTracker tracker, Analyzer analyzer, NodeAggregator aggregator) {
        this.tracker = tracker;
        this.analyzer = analyzer;
        this.aggregator = aggregator;
    }

    @Override
    public String getIndexName() {
        return "lucene";
    }

    @Override
    public double getCost(Filter filter, NodeState root) {
        if (this.tracker.getIndexNode("/") == null) {
            return Double.POSITIVE_INFINITY;
        }
        FullTextExpression ft = filter.getFullTextConstraint();
        if (ft == null) {
            return Double.POSITIVE_INFINITY;
        }
        Set<String> relPaths = LuceneIndex.getRelativePaths(ft);
        if (relPaths.size() > 1) {
            LOG.warn("More than one relative parent for query " + filter.getQueryStatement());
            return new MultiLuceneIndex(filter, root, relPaths).getCost();
        }
        String parent = relPaths.iterator().next();
        if (parent.isEmpty()) {
            return 10.0;
        }
        return 15.0;
    }

    private static Set<String> getRelativePaths(FullTextExpression ft) {
        if (ft == null) {
            return Collections.emptySet();
        }
        final HashSet<String> relPaths = new HashSet<String>();
        ft.accept(new FullTextVisitor.FullTextVisitorBase(){

            @Override
            public boolean visit(FullTextTerm term) {
                String p = term.getPropertyName();
                if (p == null) {
                    relPaths.add("");
                } else {
                    if (p.startsWith("../") || p.startsWith("./")) {
                        throw new IllegalArgumentException("Relative parent is not supported:" + p);
                    }
                    if (PathUtils.getDepth(p) > 1) {
                        String parent = PathUtils.getParentPath(p);
                        relPaths.add(parent);
                    } else {
                        relPaths.add("");
                    }
                }
                return true;
            }
        });
        return relPaths;
    }

    @Override
    public String getPlan(Filter filter, NodeState root) {
        IndexNode index = this.tracker.getIndexNode("/");
        Preconditions.checkState((index != null ? 1 : 0) != 0, (Object)"The Lucene index is not available");
        FullTextExpression ft = filter.getFullTextConstraint();
        Set<String> relPaths = LuceneIndex.getRelativePaths(ft);
        if (relPaths.size() > 1) {
            return new MultiLuceneIndex(filter, root, relPaths).getPlan();
        }
        String parent = relPaths.size() == 0 ? "" : relPaths.iterator().next();
        boolean nonFullTextConstraints = parent.isEmpty();
        String plan = LuceneIndex.getQuery(filter, null, nonFullTextConstraints, this.analyzer, index.getDefinition()) + " ft:(" + ft + ")";
        if (!parent.isEmpty()) {
            plan = plan + " parent:" + parent;
        }
        return plan;
    }

    @Override
    public Cursor query(final Filter filter, NodeState root) {
        final IndexNode index = this.tracker.getIndexNode("/");
        Preconditions.checkState((index != null ? 1 : 0) != 0, (Object)"The Lucene index is not available");
        FullTextExpression ft = filter.getFullTextConstraint();
        Set<String> relPaths = LuceneIndex.getRelativePaths(ft);
        if (relPaths.size() > 1) {
            return new MultiLuceneIndex(filter, root, relPaths).query();
        }
        final String parent = relPaths.size() == 0 ? "" : relPaths.iterator().next();
        final boolean nonFullTextConstraints = parent.isEmpty();
        final int parentDepth = PathUtils.getDepth(parent);
        QueryEngineSettings settings = filter.getQueryEngineSettings();
        AbstractIterator<LuceneResultRow> itr = new AbstractIterator<LuceneResultRow>(){
            private final Deque<LuceneResultRow> queue = Queues.newArrayDeque();
            private final Set<String> seenPaths = Sets.newHashSet();
            private ScoreDoc lastDoc;

            protected LuceneResultRow computeNext() {
                if (!this.queue.isEmpty() || this.loadDocs()) {
                    return this.queue.remove();
                }
                return (LuceneResultRow)this.endOfData();
            }

            private LuceneResultRow convertToRow(ScoreDoc doc, IndexSearcher searcher) throws IOException {
                IndexReader reader = searcher.getIndexReader();
                PathStoredFieldVisitor visitor = new PathStoredFieldVisitor();
                reader.document(doc.doc, (StoredFieldVisitor)visitor);
                String path = visitor.getPath();
                if (path != null) {
                    if ("".equals(path)) {
                        path = "/";
                    }
                    if (!parent.isEmpty()) {
                        if (this.seenPaths.contains(path = PathUtils.getAncestorPath(path, parentDepth))) {
                            return null;
                        }
                        this.seenPaths.add(path);
                    }
                    return new LuceneResultRow(path, doc.score);
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean loadDocs() {
                IndexNode indexNode = null;
                IndexSearcher searcher = null;
                ScoreDoc lastDocToRecord = null;
                try {
                    indexNode = this.acquire();
                    searcher = indexNode.acquireSearcher();
                    Query query = LuceneIndex.getQuery(filter, searcher.getIndexReader(), nonFullTextConstraints, LuceneIndex.this.analyzer, index.getDefinition());
                    TopDocs docs = this.lastDoc != null ? searcher.searchAfter(this.lastDoc, query, 50) : searcher.search(query, 50);
                    for (ScoreDoc doc : docs.scoreDocs) {
                        LuceneResultRow row = this.convertToRow(doc, searcher);
                        if (row != null) {
                            this.queue.add(row);
                        }
                        lastDocToRecord = doc;
                    }
                }
                catch (IOException e) {
                    LOG.warn("query via {} failed.", (Object)LuceneIndex.this, (Object)e);
                }
                finally {
                    this.release(indexNode, searcher);
                }
                if (lastDocToRecord != null) {
                    this.lastDoc = lastDocToRecord;
                }
                return !this.queue.isEmpty();
            }

            private IndexNode acquire() {
                return LuceneIndex.this.tracker.getIndexNode("/");
            }

            private void release(IndexNode indexNode, IndexSearcher searcher) {
                try {
                    if (searcher != null) {
                        indexNode.releaseSearcher();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Error occurred while releasing/closing the IndexSearcher", (Throwable)e);
                }
            }
        };
        return new LucenePathCursor((Iterator<LuceneResultRow>)itr, settings);
    }

    private static Query getQuery(Filter filter, IndexReader reader, boolean nonFullTextConstraints, Analyzer analyzer, NodeState indexDefinition) {
        ArrayList<Query> qs = new ArrayList<Query>();
        FullTextExpression ft = filter.getFullTextConstraint();
        if (ft != null) {
            qs.add(LuceneIndex.getFullTextQuery(ft, analyzer, reader));
        }
        Filter.PropertyRestriction pr = filter.getPropertyRestriction(NATIVE_QUERY_FUNCTION);
        if (pr != null) {
            String query = String.valueOf(pr.first.getValue(pr.first.getType()));
            QueryParser queryParser = new QueryParser(LuceneIndexConstants.VERSION, "", analyzer);
            if (query.startsWith("mlt?")) {
                Query moreLikeThis;
                String mltQueryString = query.replace("mlt?", "");
                if (reader != null && (moreLikeThis = MoreLikeThisHelper.getMoreLikeThis(reader, analyzer, mltQueryString)) != null) {
                    qs.add(moreLikeThis);
                }
            } else {
                try {
                    qs.add(queryParser.parse(query));
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (nonFullTextConstraints) {
            LuceneIndex.addNonFullTextConstraints(qs, filter, reader, analyzer, indexDefinition);
        }
        if (qs.size() == 0) {
            return new MatchAllDocsQuery();
        }
        if (qs.size() == 1) {
            return (Query)qs.get(0);
        }
        BooleanQuery bq = new BooleanQuery();
        for (Query q : qs) {
            bq.add(q, BooleanClause.Occur.MUST);
        }
        return bq;
    }

    private static void addNonFullTextConstraints(List<Query> qs, Filter filter, IndexReader reader, Analyzer analyzer, NodeState indexDefinition) {
        if (!filter.matchesAllTypes()) {
            LuceneIndex.addNodeTypeConstraints(qs, filter);
        }
        String path = filter.getPath();
        switch (filter.getPathRestriction()) {
            case ALL_CHILDREN: {
                if ("/".equals(path)) break;
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                qs.add((Query)new PrefixQuery(TermFactory.newPathTerm(path)));
                break;
            }
            case DIRECT_CHILDREN: {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                qs.add((Query)new PrefixQuery(TermFactory.newPathTerm(path)));
                break;
            }
            case EXACT: {
                qs.add((Query)new TermQuery(TermFactory.newPathTerm(path)));
                break;
            }
            case PARENT: {
                if (PathUtils.denotesRoot(path)) {
                    qs.add((Query)new TermQuery(new Term(":path", "///")));
                    break;
                }
                qs.add((Query)new TermQuery(TermFactory.newPathTerm(PathUtils.getParentPath(path))));
                break;
            }
        }
        for (Filter.PropertyRestriction pr : filter.getPropertyRestrictions()) {
            String name;
            if (pr.first == null && pr.last == null || LuceneIndex.isExcludedProperty(pr, indexDefinition) || "rep:excerpt".equals(name = pr.propertyName) || "jcr:primaryType".equals(name)) continue;
            if (LuceneIndexHelper.skipTokenization(name)) {
                qs.add((Query)new TermQuery(new Term(name, pr.first.getValue(Type.STRING))));
                continue;
            }
            String first = null;
            String last = null;
            boolean isLike = pr.isLike;
            if (pr.first != null) {
                first = pr.first.getValue(Type.STRING);
                first = first.replace("\\", "");
            }
            if (pr.last != null) {
                last = pr.last.getValue(Type.STRING);
                last = last.replace("\\", "");
            }
            if (isLike) {
                first = first.replace('%', '*');
                first = first.replace('_', '?');
                int indexOfWS = first.indexOf(42);
                int indexOfWC = first.indexOf(63);
                int len = first.length();
                if (indexOfWS == len || indexOfWC == len) {
                    first = first.substring(0, first.length() - 1);
                    if ("jcr:path".equals(name)) {
                        qs.add((Query)new PrefixQuery(TermFactory.newPathTerm(first)));
                        continue;
                    }
                    qs.add((Query)new PrefixQuery(new Term(name, first)));
                    continue;
                }
                if ("jcr:path".equals(name)) {
                    qs.add((Query)new WildcardQuery(TermFactory.newPathTerm(first)));
                    continue;
                }
                qs.add((Query)new WildcardQuery(new Term(name, first)));
                continue;
            }
            if (first != null && first.equals(last) && pr.firstIncluding && pr.lastIncluding) {
                if ("jcr:path".equals(name)) {
                    qs.add((Query)new TermQuery(TermFactory.newPathTerm(first)));
                    continue;
                }
                if ("*".equals(name)) {
                    LuceneIndex.addReferenceConstraint(first, qs, reader);
                    continue;
                }
                for (String t : LuceneIndex.tokenize(first, analyzer)) {
                    qs.add((Query)new TermQuery(new Term(name, t)));
                }
                continue;
            }
            first = LuceneIndex.tokenizeAndPoll(first, analyzer);
            last = LuceneIndex.tokenizeAndPoll(last, analyzer);
            qs.add((Query)TermRangeQuery.newStringRange((String)name, (String)first, (String)last, (boolean)pr.firstIncluding, (boolean)pr.lastIncluding));
        }
    }

    private static String tokenizeAndPoll(String token, Analyzer analyzer) {
        List<String> tokens;
        if (token != null && !(tokens = LuceneIndex.tokenize(token, analyzer)).isEmpty()) {
            token = tokens.get(0);
        }
        return token;
    }

    private static boolean isExcludedProperty(Filter.PropertyRestriction pr, NodeState definition) {
        String name = pr.propertyName;
        if (name.contains("/")) {
            return true;
        }
        for (String e : definition.getStrings("excludePropertyNames")) {
            if (!e.equalsIgnoreCase(name)) continue;
            return true;
        }
        Integer type = null;
        if (pr.first != null) {
            type = pr.first.getType().tag();
        } else if (pr.last != null) {
            type = pr.last.getType().tag();
        } else if (pr.list != null && !pr.list.isEmpty()) {
            type = pr.list.get(0).getType().tag();
        }
        if (type != null) {
            boolean isIn = false;
            for (String e : definition.getStrings("includePropertyTypes")) {
                if (PropertyType.valueFromName((String)e) != type) continue;
                isIn = true;
            }
            if (!isIn) {
                return true;
            }
        }
        return false;
    }

    private static void addReferenceConstraint(String uuid, List<Query> qs, IndexReader reader) {
        if (reader == null) {
            qs.add((Query)new TermQuery(new Term("*", uuid)));
            return;
        }
        BooleanQuery bq = new BooleanQuery();
        Collection fields = MultiFields.getIndexedFields((IndexReader)reader);
        for (String f : fields) {
            bq.add((Query)new TermQuery(new Term(f, uuid)), BooleanClause.Occur.SHOULD);
        }
        qs.add((Query)bq);
    }

    private static void addNodeTypeConstraints(List<Query> qs, Filter filter) {
        BooleanQuery bq = new BooleanQuery();
        for (String type : filter.getPrimaryTypes()) {
            bq.add((Query)new TermQuery(new Term("jcr:primaryType", type)), BooleanClause.Occur.SHOULD);
        }
        for (String type : filter.getMixinTypes()) {
            bq.add((Query)new TermQuery(new Term("jcr:mixinTypes", type)), BooleanClause.Occur.SHOULD);
        }
        qs.add((Query)bq);
    }

    static Query getFullTextQuery(FullTextExpression ft, final Analyzer analyzer, final IndexReader reader) {
        final AtomicReference result = new AtomicReference();
        ft.accept(new FullTextVisitor(){

            @Override
            public boolean visit(FullTextOr or) {
                BooleanQuery q = new BooleanQuery();
                for (FullTextExpression e : or.list) {
                    Query x = LuceneIndex.getFullTextQuery(e, analyzer, reader);
                    q.add(x, BooleanClause.Occur.SHOULD);
                }
                result.set(q);
                return true;
            }

            @Override
            public boolean visit(FullTextAnd and) {
                BooleanQuery q = new BooleanQuery();
                for (FullTextExpression e : and.list) {
                    Query x = LuceneIndex.getFullTextQuery(e, analyzer, reader);
                    if (x instanceof BooleanQuery) {
                        BooleanQuery bq = (BooleanQuery)x;
                        for (BooleanClause c : bq.clauses()) {
                            q.add(c);
                        }
                        continue;
                    }
                    q.add(x, BooleanClause.Occur.MUST);
                }
                result.set(q);
                return true;
            }

            @Override
            public boolean visit(FullTextTerm term) {
                Query q;
                String p = term.getPropertyName();
                if (p != null && p.indexOf(47) >= 0) {
                    p = PathUtils.getName(p);
                }
                if ((q = LuceneIndex.tokenToQuery(term.getText(), p, analyzer, reader)) == null) {
                    return false;
                }
                String boost = term.getBoost();
                if (boost != null) {
                    q.setBoost(Float.parseFloat(boost));
                }
                if (term.isNot()) {
                    BooleanQuery bq = new BooleanQuery();
                    bq.add(q, BooleanClause.Occur.MUST_NOT);
                    result.set(bq);
                } else {
                    result.set(q);
                }
                return true;
            }
        });
        return (Query)result.get();
    }

    static Query tokenToQuery(String text, String fieldName, Analyzer analyzer, IndexReader reader) {
        if (analyzer == null) {
            return null;
        }
        List<String> tokens = LuceneIndex.tokenize(text, analyzer);
        if (tokens.isEmpty()) {
            return new BooleanQuery();
        }
        if (tokens.size() == 1) {
            String token = tokens.iterator().next();
            if (LuceneIndex.hasFulltextToken(token)) {
                return new WildcardQuery(TermFactory.newFulltextTerm(token, fieldName));
            }
            return new TermQuery(TermFactory.newFulltextTerm(token, fieldName));
        }
        if (LuceneIndex.hasFulltextToken(tokens)) {
            MultiPhraseQuery mpq = new MultiPhraseQuery();
            for (String token : tokens) {
                if (LuceneIndex.hasFulltextToken(token)) {
                    Term[] terms = LuceneIndex.extractMatchingTokens(reader, fieldName, token);
                    if (terms == null || terms.length <= 0) continue;
                    mpq.add(terms);
                    continue;
                }
                mpq.add(TermFactory.newFulltextTerm(token, fieldName));
            }
            return mpq;
        }
        PhraseQuery pq = new PhraseQuery();
        for (String t : tokens) {
            pq.add(TermFactory.newFulltextTerm(t, fieldName));
        }
        return pq;
    }

    private static Term[] extractMatchingTokens(IndexReader reader, String fieldName, String token) {
        if (reader == null) {
            return null;
        }
        try {
            BytesRef text;
            ArrayList<Term> terms = new ArrayList<Term>();
            Term onTerm = TermFactory.newFulltextTerm(token, fieldName);
            Terms t = MultiFields.getTerms((IndexReader)reader, (String)onTerm.field());
            Automaton a = WildcardQuery.toAutomaton((Term)onTerm);
            CompiledAutomaton ca = new CompiledAutomaton(a);
            TermsEnum te = ca.getTermsEnum(t);
            while ((text = te.next()) != null) {
                terms.add(TermFactory.newFulltextTerm(text.utf8ToString(), fieldName));
            }
            return terms.toArray(new Term[terms.size()]);
        }
        catch (IOException e) {
            LOG.error("Building fulltext query failed", (Object)e.getMessage());
            return null;
        }
    }

    private static boolean hasFulltextToken(List<String> tokens) {
        for (String token : tokens) {
            if (!LuceneIndex.hasFulltextToken(token)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasFulltextToken(String token) {
        for (char c : fulltextTokens) {
            if (token.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> tokenize(String text, Analyzer analyzer) {
        ArrayList<String> tokens = new ArrayList<String>();
        TokenStream stream = null;
        try {
            stream = analyzer.tokenStream(":fulltext", (Reader)new StringReader(text));
            CharTermAttribute termAtt = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
            stream.reset();
            int poz = 0;
            boolean hasFulltextToken = false;
            StringBuilder token = new StringBuilder();
            while (stream.incrementToken()) {
                String term = termAtt.toString();
                int start = offsetAtt.startOffset();
                int end = offsetAtt.endOffset();
                if (start > poz) {
                    for (int i = poz; i < start; ++i) {
                        for (char c : fulltextTokens) {
                            if (c != text.charAt(i)) continue;
                            token.append(c);
                            hasFulltextToken = true;
                        }
                    }
                }
                poz = end;
                if (hasFulltextToken) {
                    token.append(term);
                    hasFulltextToken = false;
                    continue;
                }
                if (token.length() > 0) {
                    tokens.add(token.toString());
                }
                token = new StringBuilder();
                token.append(term);
            }
            if (poz < text.length()) {
                for (int i = poz; i < text.length(); ++i) {
                    for (char c : fulltextTokens) {
                        if (c != text.charAt(i)) continue;
                        token.append(c);
                    }
                }
            }
            if (token.length() > 0) {
                tokens.add(token.toString());
            }
            stream.end();
        }
        catch (IOException e) {
            LOG.error("Building fulltext query failed", (Object)e.getMessage());
            List<String> list = null;
            return list;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        return tokens;
    }

    @Override
    public NodeAggregator getNodeAggregator() {
        return this.aggregator;
    }

    private static class PathStoredFieldVisitor
    extends StoredFieldVisitor {
        private String path;
        private boolean pathVisited;

        private PathStoredFieldVisitor() {
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            if (":path".equals(fieldInfo.name)) {
                return StoredFieldVisitor.Status.YES;
            }
            return this.pathVisited ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
        }

        public void stringField(FieldInfo fieldInfo, String value) throws IOException {
            if (":path".equals(fieldInfo.name)) {
                this.path = value;
                this.pathVisited = true;
            }
        }

        public String getPath() {
            return this.path;
        }
    }

    static class LucenePathCursor
    implements Cursor {
        private final Cursor pathCursor;
        LuceneResultRow currentRow;

        LucenePathCursor(final Iterator<LuceneResultRow> it, QueryEngineSettings settings) {
            Iterator<String> pathIterator = new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    LucenePathCursor.this.currentRow = (LuceneResultRow)it.next();
                    return LucenePathCursor.this.currentRow.path;
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
            this.pathCursor = new Cursors.PathCursor(pathIterator, true, settings);
        }

        @Override
        public boolean hasNext() {
            return this.pathCursor.hasNext();
        }

        @Override
        public void remove() {
            this.pathCursor.remove();
        }

        @Override
        public IndexRow next() {
            final IndexRow pathRow = this.pathCursor.next();
            return new IndexRow(){

                @Override
                public String getPath() {
                    return pathRow.getPath();
                }

                @Override
                public PropertyValue getValue(String columnName) {
                    if ("jcr:score".equals(columnName)) {
                        return PropertyValues.newDouble(LucenePathCursor.this.currentRow.score);
                    }
                    return pathRow.getValue(columnName);
                }
            };
        }
    }

    static class LuceneResultRow {
        final String path;
        final double score;

        LuceneResultRow(String path, double score) {
            this.path = path;
            this.score = score;
        }

        public String toString() {
            return String.format("%s (%1.2f)", this.path, this.score);
        }
    }
}

