/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.OakCodec;
import org.apache.jackrabbit.oak.plugins.index.lucene.OakDirectory;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexEditorContext {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexEditorContext.class);
    private final IndexWriterConfig config;
    private static final Parser parser = new AutoDetectParser();
    private final NodeBuilder definition;
    private IndexWriter writer = null;
    private final int propertyTypes;
    private final Set<String> excludes;
    private long indexedNodes;
    private boolean storageEnabled = true;
    private final IndexUpdateCallback updateCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexWriterConfig getIndexWriterConfig(Analyzer analyzer) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(IndexWriterConfig.class.getClassLoader());
        try {
            IndexWriterConfig config = new IndexWriterConfig(LuceneIndexConstants.VERSION, analyzer);
            config.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
            config.setCodec((Codec)new OakCodec());
            IndexWriterConfig indexWriterConfig = config;
            return indexWriterConfig;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    private static Directory newIndexDirectory(NodeBuilder definition) throws IOException {
        String path = definition.getString("path");
        if (path == null) {
            return new OakDirectory(definition.child(":data"));
        }
        File file = new File(path);
        file.mkdirs();
        return FSDirectory.open((File)file, (LockFactory)NoLockFactory.getNoLockFactory());
    }

    LuceneIndexEditorContext(NodeBuilder definition, Analyzer analyzer, IndexUpdateCallback updateCallback) {
        this.definition = definition;
        this.config = LuceneIndexEditorContext.getIndexWriterConfig(analyzer);
        PropertyState pst = definition.getProperty("includePropertyTypes");
        if (pst != null) {
            int types = 0;
            for (String inc : pst.getValue(Type.STRINGS)) {
                try {
                    types |= 1 << PropertyType.valueFromName((String)inc);
                }
                catch (IllegalArgumentException e) {
                    log.warn("Unknown property type: " + inc);
                }
            }
            this.propertyTypes = types;
        } else {
            this.propertyTypes = -1;
        }
        PropertyState pse = definition.getProperty("excludePropertyNames");
        this.excludes = pse != null ? ImmutableSet.copyOf(pse.getValue(Type.STRINGS)) : ImmutableSet.of();
        PropertyState storage = definition.getProperty("oak.experimental.storage");
        this.storageEnabled = storage == null || storage.getValue(Type.BOOLEAN) != false;
        this.indexedNodes = 0L;
        this.updateCallback = updateCallback;
    }

    int getPropertyTypes() {
        return this.propertyTypes;
    }

    boolean includeProperty(String name) {
        return !this.excludes.contains(name);
    }

    Parser getParser() {
        return parser;
    }

    IndexWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new IndexWriter(LuceneIndexEditorContext.newIndexDirectory(this.definition), this.config);
        }
        return this.writer;
    }

    void closeWriter() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public long incIndexedNodes() {
        ++this.indexedNodes;
        return this.indexedNodes;
    }

    public long getIndexedNodes() {
        return this.indexedNodes;
    }

    void indexUpdate() throws CommitFailedException {
        this.updateCallback.indexUpdate();
    }

    public boolean isStored(String name) {
        return this.storageEnabled;
    }
}

