/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.analysis.Analyzer;

@Component
@Service(value={IndexEditorProvider.class})
public class LuceneIndexEditorProvider
implements IndexEditorProvider {
    private Analyzer analyzer = LuceneIndexConstants.ANALYZER;

    @Override
    public Editor getIndexEditor(String type, NodeBuilder definition, NodeState root, IndexUpdateCallback callback) throws CommitFailedException {
        if ("lucene".equals(type)) {
            return new LuceneIndexEditor(definition, this.analyzer, callback);
        }
        return null;
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public LuceneIndexEditorProvider with(Analyzer analyzer) {
        this.setAnalyzer(analyzer);
        return this;
    }
}

