/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public class LuceneIndexHelper {
    public static final Set<String> JR_PROPERTY_INCLUDES = ImmutableSet.of((Object)"String", (Object)"Binary");
    private static final Set<String> NOT_TOKENIZED = Sets.newHashSet((Object[])new String[]{"jcr:uuid"});

    private LuceneIndexHelper() {
    }

    public static NodeBuilder newLuceneIndexDefinition(@Nonnull NodeBuilder index, @Nonnull String name, @Nullable Set<String> propertyTypes) {
        return LuceneIndexHelper.newLuceneIndexDefinition(index, name, propertyTypes, null, null, null);
    }

    public static NodeBuilder newLuceneIndexDefinition(@Nonnull NodeBuilder index, @Nonnull String name, @Nullable Set<String> propertyTypes, @Nullable Set<String> excludes, @Nullable String async) {
        return LuceneIndexHelper.newLuceneIndexDefinition(index, name, propertyTypes, excludes, async, null);
    }

    public static NodeBuilder newLuceneIndexDefinition(@Nonnull NodeBuilder index, @Nonnull String name, @Nullable Set<String> propertyTypes, @Nullable Set<String> excludes, @Nullable String async, @Nullable Boolean stored) {
        if (index.hasChildNode(name)) {
            return index.child(name);
        }
        index = index.child(name);
        index.setProperty("jcr:primaryType", "oak:QueryIndexDefinition", Type.NAME).setProperty("type", "lucene").setProperty("reindex", true);
        if (async != null) {
            index.setProperty("async", async);
        }
        if (propertyTypes != null && !propertyTypes.isEmpty()) {
            index.setProperty(PropertyStates.createProperty("includePropertyTypes", propertyTypes, Type.STRINGS));
        }
        if (excludes != null && !excludes.isEmpty()) {
            index.setProperty(PropertyStates.createProperty("excludePropertyNames", excludes, Type.STRINGS));
        }
        if (stored != null) {
            index.setProperty(PropertyStates.createProperty("oak.experimental.storage", stored));
        }
        return index;
    }

    public static NodeBuilder newLuceneFileIndexDefinition(@Nonnull NodeBuilder index, @Nonnull String name, @Nullable Set<String> propertyTypes, @Nonnull String path) {
        return LuceneIndexHelper.newLuceneFileIndexDefinition(index, name, propertyTypes, null, path, null);
    }

    public static NodeBuilder newLuceneFileIndexDefinition(@Nonnull NodeBuilder index, @Nonnull String name, @Nullable Set<String> propertyTypes, @Nullable Set<String> excludes, @Nonnull String path, @Nullable String async) {
        if (index.hasChildNode(name)) {
            return index.child(name);
        }
        index = index.child(name);
        index.setProperty("jcr:primaryType", "oak:QueryIndexDefinition", Type.NAME).setProperty("type", "lucene").setProperty("persistence", "file").setProperty("path", path).setProperty("reindex", true);
        if (async != null) {
            index.setProperty("async", async);
        }
        if (propertyTypes != null && !propertyTypes.isEmpty()) {
            index.setProperty(PropertyStates.createProperty("includePropertyTypes", propertyTypes, Type.STRINGS));
        }
        if (excludes != null && !excludes.isEmpty()) {
            index.setProperty(PropertyStates.createProperty("excludePropertyNames", excludes, Type.STRINGS));
        }
        return index;
    }

    public static boolean skipTokenization(String name) {
        return NOT_TOKENIZED.contains(name);
    }

    static {
        NOT_TOKENIZED.addAll(UserConstants.USER_PROPERTY_NAMES);
        NOT_TOKENIZED.addAll(UserConstants.GROUP_PROPERTY_NAMES);
    }
}

