/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.ArrayBasedBlob;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MutableNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.EqualsDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class MemoryNodeBuilder
implements NodeBuilder {
    private final MemoryNodeBuilder parent;
    private final String name;
    private final MemoryNodeBuilder rootBuilder;
    private long baseRevision;
    @Nonnull
    private NodeState base;
    private final RootHead rootHead;
    private Head head;

    protected MemoryNodeBuilder(MemoryNodeBuilder parent, String name) {
        this.parent = parent;
        this.name = name;
        this.rootBuilder = parent.rootBuilder;
        this.base = parent.base().getChildNode(name);
        this.baseRevision = parent.baseRevision;
        this.rootHead = parent.rootHead;
        this.head = new UnconnectedHead(this, this.base);
    }

    public MemoryNodeBuilder(@Nonnull NodeState base) {
        this.parent = null;
        this.name = null;
        this.rootBuilder = this;
        this.baseRevision = 0L;
        this.base = (NodeState)Preconditions.checkNotNull((Object)base);
        this.rootHead = new RootHead(this);
        this.head = this.rootHead;
    }

    private Head head() {
        return this.head.update();
    }

    protected final boolean isRoot() {
        return this == this.rootBuilder;
    }

    @Nonnull
    private NodeState base() {
        if (this.rootBuilder.baseRevision != this.baseRevision) {
            this.base = this.parent.base().getChildNode(this.name);
            this.baseRevision = this.rootBuilder.baseRevision;
        }
        return this.base;
    }

    protected MemoryNodeBuilder createChildBuilder(String name) {
        return new MemoryNodeBuilder(this, name);
    }

    protected void updated() {
        if (this != this.rootBuilder) {
            this.rootBuilder.updated();
        }
    }

    protected final MemoryNodeBuilder getParent() {
        return this.parent;
    }

    protected final String getName() {
        return this.name;
    }

    public void reset(@Nonnull NodeState newBase) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0);
        this.base = (NodeState)Preconditions.checkNotNull((Object)newBase);
        this.baseRevision = this.rootHead.setState(newBase) + 1L;
    }

    protected void set(NodeState newHead) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0);
        this.baseRevision = this.rootHead.setState(newHead);
    }

    @Override
    @Nonnull
    public NodeState getNodeState() {
        return this.head().getImmutableNodeState();
    }

    @Override
    @Nonnull
    public NodeState getBaseState() {
        return this.base();
    }

    @Override
    public boolean exists() {
        return this.head().getCurrentNodeState().exists();
    }

    @Override
    public boolean isNew() {
        return this.exists() && !this.getBaseState().exists();
    }

    @Override
    public boolean isNew(String name) {
        return this.hasProperty(name) && !this.getBaseState().hasProperty(name);
    }

    @Override
    public boolean isModified() {
        return this.head().isModified();
    }

    @Override
    public boolean isReplaced() {
        return this.head().isReplaced();
    }

    @Override
    public boolean isReplaced(String name) {
        return this.head().isReplaced(name);
    }

    @Override
    public long getChildNodeCount(long max) {
        return this.head().getCurrentNodeState().getChildNodeCount(max);
    }

    @Override
    public Iterable<String> getChildNodeNames() {
        return this.head().getCurrentNodeState().getChildNodeNames();
    }

    @Override
    public boolean hasChildNode(String name) {
        return this.head().getCurrentNodeState().hasChildNode((String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    public NodeBuilder child(String name) {
        if (this.hasChildNode(name)) {
            return this.getChildNode(name);
        }
        return this.setChildNode(name);
    }

    @Override
    public NodeBuilder getChildNode(String name) {
        AbstractNodeState.checkValidName(name);
        return this.createChildBuilder(name);
    }

    @Override
    public NodeBuilder setChildNode(String name) {
        return this.setChildNode(name, EmptyNodeState.EMPTY_NODE);
    }

    @Override
    public NodeBuilder setChildNode(String name, NodeState state) {
        Preconditions.checkState((boolean)this.exists(), (Object)("This builder does not exist: " + this.name));
        this.head().getMutableNodeState().setChildNode(name, (NodeState)Preconditions.checkNotNull((Object)state));
        MemoryNodeBuilder builder = this.createChildBuilder(name);
        this.updated();
        return builder;
    }

    @Override
    public boolean remove() {
        if (!this.isRoot() && this.exists()) {
            this.head().getMutableNodeState();
            this.parent.head().getMutableNodeState().removeChildNode(this.name);
            this.updated();
            return true;
        }
        return false;
    }

    @Override
    public boolean moveTo(NodeBuilder newParent, String newName) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)newParent);
        AbstractNodeState.checkValidName(newName);
        if (this.isRoot() || !this.exists() || newParent.hasChildNode(newName)) {
            return false;
        }
        if (newParent.exists()) {
            this.annotateSourcePath();
            NodeState nodeState = this.getNodeState();
            newParent.setChildNode(newName, nodeState);
            this.remove();
            return true;
        }
        return false;
    }

    protected final void annotateSourcePath() {
        String sourcePath = this.getSourcePath();
        if (!this.isTransientlyAdded(sourcePath)) {
            this.setProperty(":source-path", sourcePath);
        }
    }

    private final String getSourcePath() {
        MemoryNodeBuilder builder = this;
        String sourcePath = MemoryNodeBuilder.getSourcePathAnnotation(builder);
        while (sourcePath == null && builder.parent != null) {
            builder = builder.parent;
            sourcePath = MemoryNodeBuilder.getSourcePathAnnotation(builder);
        }
        if (sourcePath == null) {
            return this.getPath();
        }
        return PathUtils.concat(sourcePath, PathUtils.relativize(builder.getPath(), this.getPath()));
    }

    private static String getSourcePathAnnotation(MemoryNodeBuilder builder) {
        PropertyState head;
        PropertyState base = builder.getBaseState().getProperty(":source-path");
        if (Objects.equal((Object)base, (Object)(head = builder.getNodeState().getProperty(":source-path")))) {
            return null;
        }
        return head.getValue(Type.STRING);
    }

    private boolean isTransientlyAdded(String path) {
        NodeState node = this.rootBuilder.getBaseState();
        for (String name : PathUtils.elements(path)) {
            node = node.getChildNode(name);
        }
        return !node.exists();
    }

    @Override
    public long getPropertyCount() {
        return this.head().getCurrentNodeState().getPropertyCount();
    }

    @Override
    public Iterable<? extends PropertyState> getProperties() {
        return this.head().getCurrentNodeState().getProperties();
    }

    @Override
    public boolean hasProperty(String name) {
        return this.head().getCurrentNodeState().hasProperty((String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    public PropertyState getProperty(String name) {
        return this.head.update().getCurrentNodeState().getProperty((String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    public boolean getBoolean(String name) {
        return this.head().getCurrentNodeState().getBoolean((String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    @CheckForNull
    public String getString(@Nonnull String name) {
        return this.head().getCurrentNodeState().getString((String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    @CheckForNull
    public String getName(@Nonnull String name) {
        return this.head().getCurrentNodeState().getName((String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    @Nonnull
    public Iterable<String> getNames(@Nonnull String name) {
        return this.head().getCurrentNodeState().getNames((String)Preconditions.checkNotNull((Object)name));
    }

    @Override
    public NodeBuilder setProperty(PropertyState property) {
        Preconditions.checkState((boolean)this.exists(), (Object)("This builder does not exist: " + this.name));
        this.head().getMutableNodeState().setProperty((PropertyState)Preconditions.checkNotNull((Object)property));
        this.updated();
        return this;
    }

    @Override
    public <T> NodeBuilder setProperty(String name, T value) {
        this.setProperty(PropertyStates.createProperty(name, value));
        return this;
    }

    @Override
    public <T> NodeBuilder setProperty(String name, T value, Type<T> type) {
        this.setProperty(PropertyStates.createProperty(name, value, type));
        return this;
    }

    @Override
    public NodeBuilder removeProperty(String name) {
        Preconditions.checkState((boolean)this.exists(), (Object)("This builder does not exist: " + name));
        if (this.head().getMutableNodeState().removeProperty((String)Preconditions.checkNotNull((Object)name))) {
            this.updated();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob createBlob(InputStream stream) throws IOException {
        try {
            ArrayBasedBlob arrayBasedBlob = new ArrayBasedBlob(ByteStreams.toByteArray((InputStream)stream));
            return arrayBasedBlob;
        }
        finally {
            stream.close();
        }
    }

    public final String getPath() {
        return this.parent == null ? "/" : this.getPath(new StringBuilder()).toString();
    }

    private StringBuilder getPath(StringBuilder parentPath) {
        return this.parent == null ? parentPath : this.parent.getPath(parentPath).append('/').append(this.name);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("path", (Object)this.getPath()).toString();
    }

    private static class RootHead
    extends ConnectedHead {
        public RootHead(MemoryNodeBuilder builder) {
            super(builder, new MutableNodeState(builder.base));
        }

        @Override
        public Head update() {
            return this;
        }

        public final long setState(NodeState state) {
            this.state = new MutableNodeState(state);
            ++this.revision;
            return this.revision++;
        }
    }

    private static class ConnectedHead
    implements Head {
        private final MemoryNodeBuilder builder;
        protected long revision;
        protected MutableNodeState state;

        public ConnectedHead(MemoryNodeBuilder builder, MutableNodeState state) {
            this.builder = builder;
            this.revision = builder.rootBuilder.baseRevision;
            this.state = state;
        }

        @Override
        public Head update() {
            if (this.revision != this.builder.rootBuilder.baseRevision) {
                this.builder.head = new UnconnectedHead(this.builder, this.builder.base);
                return this.builder.head.update();
            }
            return this;
        }

        @Override
        public NodeState getCurrentNodeState() {
            return this.state;
        }

        @Override
        public MutableNodeState getMutableNodeState() {
            ++((MemoryNodeBuilder)this.builder).rootHead.revision;
            return this.state;
        }

        @Override
        public NodeState getImmutableNodeState() {
            return this.state.snapshot();
        }

        @Override
        public boolean isModified() {
            return this.state.isModified(this.builder.base());
        }

        @Override
        public boolean isReplaced() {
            return this.state.isReplaced(this.builder.base());
        }

        @Override
        public boolean isReplaced(String name) {
            return this.state.isReplaced(this.builder.base(), name);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("path", (Object)this.builder.getPath()).toString();
        }
    }

    private static class UnconnectedHead
    implements Head {
        private final MemoryNodeBuilder builder;
        private final RootHead rootHead;
        private long revision;
        private NodeState state;

        UnconnectedHead(MemoryNodeBuilder builder, NodeState state) {
            this.builder = builder;
            this.rootHead = builder.rootHead;
            this.revision = builder.baseRevision;
            this.state = state;
        }

        @Override
        public Head update() {
            long rootRevision = this.rootHead.revision;
            if (this.revision != rootRevision) {
                NodeState parentState = this.builder.parent.head().getCurrentNodeState();
                NodeState newState = parentState.getChildNode(this.builder.name);
                if (newState instanceof MutableNodeState) {
                    this.builder.head = new ConnectedHead(this.builder, (MutableNodeState)newState);
                    return this.builder.head;
                }
                this.state = newState;
                this.revision = rootRevision;
            }
            return this;
        }

        @Override
        public NodeState getCurrentNodeState() {
            return this.state;
        }

        @Override
        public MutableNodeState getMutableNodeState() {
            MutableNodeState parentState = this.builder.parent.head().getMutableNodeState();
            MutableNodeState state = parentState.getMutableChildNode(this.builder.name);
            return new ConnectedHead(this.builder, state).getMutableNodeState();
        }

        @Override
        public NodeState getImmutableNodeState() {
            assert (!(this.state instanceof MutableNodeState));
            return this.state;
        }

        @Override
        public boolean isModified() {
            return EqualsDiff.modified(this.builder.base(), this.state);
        }

        @Override
        public boolean isReplaced() {
            return false;
        }

        @Override
        public boolean isReplaced(String name) {
            return false;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("path", (Object)this.builder.getPath()).toString();
        }
    }

    private static interface Head {
        public Head update();

        public NodeState getCurrentNodeState();

        public MutableNodeState getMutableNodeState();

        public NodeState getImmutableNodeState();

        public boolean isModified();

        public boolean isReplaced();

        public boolean isReplaced(String var1);
    }
}

